/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.DefaultGenType;
import io.goodforgod.dummymaker.GenClass;
import io.goodforgod.dummymaker.GenConstructor;
import io.goodforgod.dummymaker.GenConstructorScanner;
import io.goodforgod.dummymaker.GenContext;
import io.goodforgod.dummymaker.GenFactory;
import io.goodforgod.dummymaker.GenField;
import io.goodforgod.dummymaker.GenFieldScanner;
import io.goodforgod.dummymaker.GenGraphBuilder;
import io.goodforgod.dummymaker.GenNode;
import io.goodforgod.dummymaker.GenParameterBuilder;
import io.goodforgod.dummymaker.GenRules;
import io.goodforgod.dummymaker.GenRulesContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.GeneratorSupplier;
import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.error.GenException;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.EmbeddedGenerator;
import io.goodforgod.dummymaker.generator.simple.number.SequenceGenerator;
import io.goodforgod.dummymaker.util.CastUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultGenFactory
implements GenFactory {
    private static final Pattern PATTERN_LOCALISATION_EN = Pattern.compile("(Eng?|English)$");
    private static final Pattern PATTERN_LOCALISATION_RU = Pattern.compile("(Ru|Russian)$");
    private final GenRules rules;
    private final GeneratorSupplier generatorSupplier;
    private final NamingCase namingCase;
    private final boolean ignoreErrors;
    private final boolean overrideDefaultValues;
    @Nullable
    private final Localisation localisation;
    private final boolean isAutoByDefault;
    private final int depthByDefault;

    DefaultGenFactory(long seed, GenRules rules, boolean isAutoByDefault, int depthByDefault, boolean ignoreErrors, boolean overrideDefaultValues, NamingCase namingCase, @Nullable Localisation localisation) {
        this.rules = rules;
        this.namingCase = namingCase;
        this.ignoreErrors = ignoreErrors;
        this.overrideDefaultValues = overrideDefaultValues;
        this.localisation = localisation;
        this.generatorSupplier = new GeneratorSupplier(seed);
        this.isAutoByDefault = isAutoByDefault;
        this.depthByDefault = depthByDefault;
    }

    @Override
    public <T> T build(@NotNull Class<T> target) {
        return this.stream(target, 1L).findFirst().orElse(null);
    }

    @Override
    public <T> T build(@NotNull Supplier<T> supplier) {
        return this.stream(supplier, 1L).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public <T> List<T> build(@NotNull Class<T> target, int size) {
        return this.stream(target, (long)size).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public <T> List<T> build(@NotNull Supplier<T> supplier, int size) {
        return this.stream(supplier, (long)size).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public <T> Stream<T> stream(@NotNull Class<T> target, long size) {
        if (size < 0L) {
            throw new GenException("Generation size can't be less than 0");
        }
        if (size == 0L) {
            return Stream.empty();
        }
        GenRulesContext rulesContext = this.rules.context();
        Generator generator = rulesContext.findClass(target).flatMap(rule -> rule.find(target)).orElseGet(() -> this.generatorSupplier.get(target));
        if (!(generator instanceof EmbeddedGenerator)) {
            return Stream.generate(() -> generator.get()).limit(size).filter(Objects::nonNull);
        }
        Optional<GenType> genType = DefaultGenType.ofInstantiatable(target);
        if (!genType.isPresent()) {
            throw new GenException("Type can't be instantiated: " + target);
        }
        GenContext context = this.getContext(target, rulesContext);
        Supplier<T> instanceSupplier = this.getInstanceSupplier(context.graph().value(), context);
        return Stream.generate(instanceSupplier).limit(size).map(instance -> this.fillInstance(instance, context));
    }

    @Override
    @NotNull
    public <T> Stream<T> stream(@NotNull Supplier<T> supplier, long size) {
        if (size < 0L) {
            throw new GenException("Generation size can't be less than 0");
        }
        if (size == 0L) {
            return Stream.empty();
        }
        T first = supplier.get();
        if (first == null) {
            return Stream.empty();
        }
        Class<?> target = first.getClass();
        GenRulesContext rulesContext = this.rules.context();
        Generator generator = rulesContext.findClass(target).flatMap(rule -> rule.find(target)).orElseGet(() -> this.generatorSupplier.get(target));
        if (!(generator instanceof EmbeddedGenerator)) {
            return Stream.generate(supplier).limit(size).filter(Objects::nonNull);
        }
        GenContext context = this.getContext(target, rulesContext);
        return Stream.generate(supplier).limit(size).filter(Objects::nonNull).map(instance -> this.fillInstance(instance, context));
    }

    private GenContext getContext(Class<?> target, GenRulesContext rulesContext) {
        GenFieldScanner fieldScanner = new GenFieldScanner(this.generatorSupplier, rulesContext, this.isAutoByDefault);
        GenConstructorScanner constructorScanner = new GenConstructorScanner(this.generatorSupplier, rulesContext, this.isAutoByDefault);
        GenGraphBuilder graphBuilder = new GenGraphBuilder(constructorScanner, fieldScanner, rulesContext, this.depthByDefault, this.ignoreErrors);
        GenNode graph = graphBuilder.build(target);
        return GenContext.ofNew(graph.value().depth(), graph, rulesContext, this.generatorSupplier, graphBuilder);
    }

    @Nullable
    <T> T fillInstance(@Nullable T instance, GenContext context) {
        block6: {
            if (instance == null || context.graph() == null) {
                return null;
            }
            try {
                List<GenField> fields = context.graph().value().fields();
                for (GenField field : fields) {
                    Object generated;
                    Object fieldDefaultValue;
                    if (!this.overrideDefaultValues && (fieldDefaultValue = field.getDefaultValue(instance)) != null || (generated = this.generateFieldValue(field, context)) == null) continue;
                    field.setValue(instance, generated);
                }
            }
            catch (GenException e) {
                if (!this.ignoreErrors) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (this.ignoreErrors) break block6;
                throw new GenException("Error occurred while generating '" + instance.getClass() + "' field value due to: ", e);
            }
        }
        return instance;
    }

    Object generateFieldValue(GenField field, GenContext context) {
        return this.generateFieldValue(field.type(), field.name(), field.generator(), context);
    }

    Object generateFieldValue(final GenType valueType, String valueName, Generator<?> valueGenerator, GenContext context) {
        Object generated;
        if (valueGenerator instanceof EmbeddedGenerator) {
            generated = this.generateEmbeddedObject(valueType, context);
        } else if (valueGenerator instanceof SequenceGenerator) {
            Object sequence = valueGenerator.get();
            generated = CastUtils.castToNumber(sequence, valueType.raw());
        } else if (valueGenerator instanceof ParameterizedGenerator) {
            final Localisation matchedLocalisation = this.localisation == null ? this.tryMatchLocalisation(valueName) : this.localisation;
            final GenParameterBuilder genParameterBuilder = this.getGenParameterBuilder(valueName, context);
            generated = ((ParameterizedGenerator)valueGenerator).get(new GenParameters(){

                @Override
                @NotNull
                public Localisation localisation() {
                    return matchedLocalisation;
                }

                @Override
                @NotNull
                public NamingCase namingCase() {
                    return DefaultGenFactory.this.namingCase;
                }

                @Override
                @NotNull
                public GenType parameterType() {
                    return valueType;
                }

                @Override
                @NotNull
                public GenParameterBuilder genericBuilder() {
                    return genParameterBuilder;
                }
            });
        } else {
            generated = valueGenerator.get();
        }
        return CastUtils.castObject(generated, valueType.raw());
    }

    private GenParameterBuilder getGenParameterBuilder(final String valueName, final GenContext context) {
        final Class<?> parentType = context.graph().value().type().raw();
        final Localisation matchedLocalisation = this.localisation == null ? this.tryMatchLocalisation(valueName) : this.localisation;
        return new GenParameterBuilder(){

            @Override
            @Nullable
            public <T> T build(final @NotNull Class<T> type) {
                Object generated;
                Generator generator = context.rules().findClass(parentType).flatMap(rule -> rule.find(type)).orElseGet(() -> context.generatorSupplier().get(type, valueName));
                if (generator instanceof EmbeddedGenerator) {
                    Optional<GenType> realType = DefaultGenType.ofInstantiatable(type);
                    if (!realType.isPresent()) {
                        return null;
                    }
                    if (context.depthCurrent() > context.depthMax() || DefaultGenFactory.this.isJavaInternal(realType.get())) {
                        generated = null;
                    } else {
                        GenType genType = realType.get();
                        GenContext checkUnknownContext = GenContext.ofChild(context, genType.raw());
                        if (checkUnknownContext.graph() == null) {
                            GenNode graph = context.graphBuilder().build(genType.raw());
                            GenContext childContext = GenContext.ofUnknown(graph, context);
                            generated = DefaultGenFactory.this.generateEmbeddedObject(genType, childContext);
                        } else {
                            generated = DefaultGenFactory.this.generateEmbeddedObject(genType, context);
                        }
                    }
                } else if (generator instanceof ParameterizedGenerator) {
                    final 2 self = this;
                    generated = ((ParameterizedGenerator)generator).get(new GenParameters(){

                        @Override
                        @NotNull
                        public Localisation localisation() {
                            return matchedLocalisation;
                        }

                        @Override
                        @NotNull
                        public NamingCase namingCase() {
                            return DefaultGenFactory.this.namingCase;
                        }

                        @Override
                        @NotNull
                        public GenType parameterType() {
                            return DefaultGenType.ofClass(type);
                        }

                        @Override
                        @NotNull
                        public GenParameterBuilder genericBuilder() {
                            return self;
                        }
                    });
                } else {
                    generated = generator.get();
                }
                return CastUtils.castObject(generated, type);
            }
        };
    }

    private boolean canGenerateEmbedded(GenType type, GenContext context) {
        Optional<GenType> realType = DefaultGenType.ofInstantiatable(type.raw());
        return context.depthCurrent() <= context.depthMax() && realType.isPresent();
    }

    private boolean isJavaInternal(GenType type) {
        Class<?> typeRaw = type.raw();
        String packageName = typeRaw.getPackage().getName();
        return packageName.equals("java") || packageName.equals("javax") || packageName.equals("jdk") || packageName.equals("sun");
    }

    private Object generateEmbeddedObject(GenType type, GenContext context) {
        if (!this.canGenerateEmbedded(type, context)) {
            return null;
        }
        GenContext childContext = GenContext.ofChild(context, type.raw());
        GenClass childClass = childContext.graph().value();
        Supplier childValue = this.getInstanceSupplier(childClass, childContext);
        return this.fillInstance(childValue.get(), childContext);
    }

    @NotNull
    private Localisation tryMatchLocalisation(String fieldName) {
        if (PATTERN_LOCALISATION_EN.matcher(fieldName).matches()) {
            return Localisation.ENGLISH;
        }
        if (PATTERN_LOCALISATION_RU.matcher(fieldName).matches()) {
            return Localisation.RUSSIAN;
        }
        return Localisation.ENGLISH;
    }

    private <T> Supplier<T> getInstanceSupplier(GenClass genClass, GenContext context) {
        GenConstructor constructor = genClass.constructor();
        return () -> {
            Object[] constructorParameters = constructor.parameters().stream().map(parameter -> this.generateFieldValue(parameter.type(), parameter.name(), parameter.generator(), context)).toArray(Object[]::new);
            try {
                return constructor.instantiate(constructorParameters);
            }
            catch (Exception e) {
                if (this.ignoreErrors) {
                    return () -> null;
                }
                throw e;
            }
        };
    }
}

