/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.DefaultGenFactory;
import io.goodforgod.dummymaker.GenFactory;
import io.goodforgod.dummymaker.GenRule;
import io.goodforgod.dummymaker.GenRules;
import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.generator.Localisation;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultGenFactoryBuilder
implements GenFactory.Builder {
    private final List<GenRule> rules = new ArrayList<GenRule>();
    private long seed = System.nanoTime();
    private boolean autoByDefault = true;
    private int depthByDefault = 7;
    private boolean ignoreErrors = false;
    private boolean overrideDefaultValues = true;
    @Nullable
    private Localisation localisation;
    private NamingCase namingCaseStrategy = NamingCases.DEFAULT;

    DefaultGenFactoryBuilder() {
    }

    @Override
    @NotNull
    public GenFactory.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder addRule(@NotNull GenRule rule) {
        this.rules.add(rule);
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder applyCase(@NotNull NamingCase namingCase) {
        this.namingCaseStrategy = namingCase;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder autoByDefault(boolean autoByDefault) {
        this.autoByDefault = autoByDefault;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder depthByDefault(int depthByDefault) {
        if (depthByDefault > 50 || depthByDefault < 1) {
            throw new IllegalArgumentException("Depth should be from 1 to 50");
        }
        this.depthByDefault = depthByDefault;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder ignoreExceptions(boolean ignoreExceptions) {
        this.ignoreErrors = ignoreExceptions;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder overrideDefaultValues(boolean overrideDefaultValues) {
        this.overrideDefaultValues = overrideDefaultValues;
        return this;
    }

    @Override
    @NotNull
    public GenFactory.Builder localisation(@NotNull Localisation localisation) {
        this.localisation = localisation;
        return this;
    }

    @Override
    @NotNull
    public GenFactory build() {
        return new DefaultGenFactory(this.seed, GenRules.of(this.rules), this.autoByDefault, this.depthByDefault, this.ignoreErrors, this.overrideDefaultValues, this.namingCaseStrategy, this.localisation);
    }
}

