/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class DefaultGenType
implements GenType {
    private final Type type;
    private final Class<?> value;
    private final List<GenType> generics;

    private DefaultGenType(Type type, Class<?> value, List<GenType> generics) {
        this.type = type;
        this.value = value;
        this.generics = generics;
    }

    static Optional<GenType> ofInstantiatable(@NotNull Class<?> type) {
        Optional<GenType> sealedClass = DefaultGenType.ofSealed(type);
        if (sealedClass.isPresent()) {
            return sealedClass;
        }
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return Optional.empty();
        }
        return Optional.of(new DefaultGenType(type, type, Collections.emptyList()));
    }

    static GenType ofClass(@NotNull Class<?> type) {
        Optional<GenType> sealedClass = DefaultGenType.ofSealed(type);
        return sealedClass.orElseGet(() -> new DefaultGenType(type, type, Collections.emptyList()));
    }

    static Optional<GenType> ofType(@NotNull Type type) {
        if (type instanceof Class) {
            return Optional.of(DefaultGenType.ofClass((Class)type));
        }
        if (type instanceof TypeVariable) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (genericDeclaration instanceof Type) {
                return DefaultGenType.ofType((Type)genericDeclaration).map(r -> new DefaultGenType(type, r.raw(), r.generics()));
            }
            return Optional.empty();
        }
        if (type instanceof ParameterizedType) {
            List<GenType> generics = Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).map(DefaultGenType::ofType).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return Optional.of(new DefaultGenType(type, (Class)((ParameterizedType)type).getRawType(), generics));
        }
        if (type instanceof WildcardType) {
            return Optional.of(new DefaultGenType(type, Object.class, Collections.emptyList()));
        }
        return Optional.empty();
    }

    private static Optional<GenType> ofSealed(@NotNull Class<?> type) {
        try {
            Method permittedMethod = Class.class.getMethod("getPermittedSubclasses", new Class[0]);
            Class[] permitted = (Class[])permittedMethod.invoke(type, new Object[0]);
            return Arrays.stream(permitted).map(DefaultGenType::ofType).findFirst().flatMap(v -> v);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Class<?> plainRawType() {
        Class<?> raw = this.raw();
        if (raw.getTypeName().endsWith("[][]")) {
            return raw.getComponentType().getComponentType();
        }
        if (raw.getTypeName().endsWith("[]")) {
            return raw.getComponentType();
        }
        return raw;
    }

    @Override
    @NotNull
    public List<GenType> flatten() {
        if (this.generics.isEmpty()) {
            return Collections.singletonList(DefaultGenType.ofClass(this.plainRawType()));
        }
        ArrayList<GenType> flat = new ArrayList<GenType>();
        flat.add(DefaultGenType.ofClass(this.plainRawType()));
        this.generics.stream().flatMap(t -> t.flatten().stream()).forEach(flat::add);
        return flat;
    }

    @Override
    @NotNull
    public Class<?> raw() {
        return this.value;
    }

    @Override
    @NotNull
    public List<GenType> generics() {
        return this.generics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultGenType)) {
            return false;
        }
        DefaultGenType that = (DefaultGenType)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.generics, that.generics);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.generics);
    }

    public String toString() {
        if (this.generics.isEmpty()) {
            return this.value.getSimpleName();
        }
        return this.generics.stream().map(Object::toString).collect(Collectors.joining(", ", this.value.getSimpleName() + "<", ">"));
    }
}

