/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenParameter;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.error.GenConstructionException;
import java.lang.reflect.Constructor;
import java.util.List;

final class GenConstructor {
    private final GenType type;
    private final Constructor<?> constructor;
    private final List<GenParameter> parameters;

    GenConstructor(GenType type, Constructor<?> constructor, List<GenParameter> parameters) {
        this.type = type;
        this.constructor = constructor;
        this.parameters = parameters;
    }

    <T> T instantiate(Object ... parameters) {
        try {
            this.constructor.setAccessible(true);
            return (T)this.constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new GenConstructionException("Exception occurred during '" + this.type + "' class instantiation due to: ", e);
        }
    }

    GenType type() {
        return this.type;
    }

    List<GenParameter> parameters() {
        return this.parameters;
    }

    public String toString() {
        return "[type=" + this.type + ']';
    }
}

