/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.DefaultGenType;
import io.goodforgod.dummymaker.GenConstructor;
import io.goodforgod.dummymaker.GenParameter;
import io.goodforgod.dummymaker.GenRuleContext;
import io.goodforgod.dummymaker.GenRulesContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.GeneratorSupplier;
import io.goodforgod.dummymaker.error.GenConstructionException;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.util.CastUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class GenConstructorScanner {
    private final GeneratorSupplier generatorSupplier;
    private final GenRulesContext rules;
    private final boolean isAutoByDefault;

    GenConstructorScanner(GeneratorSupplier generatorSupplier, GenRulesContext rules, boolean isAutoByDefault) {
        this.generatorSupplier = generatorSupplier;
        this.rules = rules;
        this.isAutoByDefault = isAutoByDefault;
    }

    @NotNull
    GenConstructor scan(@NotNull GenType target) {
        Constructor<?> constructor = GenConstructorScanner.getConstructor(target.raw());
        List<GenParameter> parameters = this.getConstructorParameters(target, constructor);
        return new GenConstructor(target, constructor, parameters);
    }

    private List<GenParameter> getConstructorParameters(GenType type, Constructor<?> constructor) {
        if (constructor.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        boolean isRecord = GenConstructorScanner.isRecord(type.raw());
        return Arrays.stream(constructor.getParameters()).map(parameter -> {
            String parameterName = isRecord ? parameter.getName() : (parameter.isNamePresent() ? parameter.getName() : Arrays.stream(type.raw().getDeclaredFields()).filter(f -> Modifier.isFinal(f.getModifiers())).filter(f -> f.getType().equals(parameter.getType())).map(Field::getName).findFirst().orElseGet(() -> Arrays.stream(type.raw().getDeclaredFields()).filter(f -> f.getType().equals(parameter.getType())).map(Field::getName).findFirst().orElse(parameter.getName())));
            GenType parameterType = DefaultGenType.ofType(parameter.getParameterizedType()).orElseGet(() -> DefaultGenType.ofClass(parameter.getType()));
            Optional<GenRuleContext> typeRule = this.rules.findClass(type);
            Optional ruleGenerator = typeRule.flatMap(r -> r.find(parameterType));
            if (ruleGenerator.isPresent()) {
                return new GenParameter(parameterType, parameterName, (Generator)ruleGenerator.get());
            }
            if (typeRule.flatMap(GenRuleContext::isAuto).orElse(this.isAutoByDefault).booleanValue() || CastUtils.isPrimitive(type.raw())) {
                Generator<?> generator = this.generatorSupplier.get(parameterType.raw(), parameterName);
                return new GenParameter(parameterType, parameterName, generator);
            }
            return new GenParameter(parameterType, parameterName, this.generatorSupplier.get(Void.class));
        }).collect(Collectors.toList());
    }

    private static Constructor<?> getConstructor(Class<?> target) {
        try {
            if (GenConstructorScanner.isRecord(target)) {
                Class[] constructorTypes = (Class[])Arrays.stream(target.getDeclaredFields()).map(Field::getType).toArray(Class[]::new);
                return target.getDeclaredConstructor(constructorTypes);
            }
            Optional<Constructor> zeroArgConstructor = Arrays.stream(target.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
            if (zeroArgConstructor.isPresent()) {
                return zeroArgConstructor.get();
            }
            Optional<Constructor> innerClassArgConstructor = Arrays.stream(target.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1).filter(c -> CastUtils.CastType.of(c.getParameterTypes()[0]).equals((Object)CastUtils.CastType.UNKNOWN)).findFirst();
            if (innerClassArgConstructor.isPresent()) {
                return innerClassArgConstructor.get();
            }
            Optional<Constructor> fullArgConstructor = Arrays.stream(target.getDeclaredConstructors()).max(Comparator.comparingInt(Constructor::getParameterCount));
            if (fullArgConstructor.isPresent()) {
                return fullArgConstructor.get();
            }
        }
        catch (Exception e) {
            throw new GenConstructionException("Exception occurred during '" + target + "' class constructor search due to: ", e);
        }
        throw new GenConstructionException("Can't instantiate '" + target + "', suitable constructor not found");
    }

    private static boolean isRecord(Class<?> target) {
        return target.getSuperclass() != null && target.getSuperclass().getCanonicalName().equals("java.lang.Record");
    }
}

