/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenGraphBuilder;
import io.goodforgod.dummymaker.GenNode;
import io.goodforgod.dummymaker.GenRulesContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.GeneratorSupplier;

final class GenContext {
    private final int depthMax;
    private final int depthCurrent;
    private final GenNode graph;
    private final GenRulesContext rules;
    private final GeneratorSupplier generatorSupplier;
    private final GenGraphBuilder graphBuilder;

    private GenContext(int depthMax, int depthCurrent, GenNode graph, GenRulesContext rules, GeneratorSupplier generatorSupplier, GenGraphBuilder graphBuilder) {
        this.depthMax = depthMax;
        this.depthCurrent = depthCurrent;
        this.graph = graph;
        this.rules = rules;
        this.generatorSupplier = generatorSupplier;
        this.graphBuilder = graphBuilder;
    }

    static GenContext ofChild(GenContext context, Class<?> target) {
        GenNode node = context.graph().nodes().stream().filter(n -> n.value().type().raw().equals(target)).findFirst().orElseGet(() -> context.graph().nodes().stream().filter(n -> n.value().type().flatten().stream().anyMatch(type -> {
            Class<?> plain = type.raw();
            if (plain.getTypeName().endsWith("[][]")) {
                plain = plain.getComponentType().getComponentType();
            } else if (plain.getTypeName().endsWith("[]")) {
                plain = plain.getComponentType();
            }
            return plain.equals(target);
        })).findFirst().orElse(null));
        return new GenContext(context.depthMax(), context.depthCurrent() + 1, node, context.rules(), context.generatorSupplier(), context.graphBuilder());
    }

    static GenContext ofParameterized(GenContext context, GenType target) {
        GenNode node = context.graph().nodes().stream().filter(n -> n.value().type().equals(target)).findFirst().orElse(null);
        return new GenContext(context.depthMax(), context.depthCurrent(), node, context.rules(), context.generatorSupplier(), context.graphBuilder());
    }

    static GenContext ofUnknown(GenNode root, GenContext context) {
        return new GenContext(context.depthMax(), context.depthCurrent(), root, context.rules(), context.generatorSupplier(), context.graphBuilder());
    }

    static GenContext ofNew(int depthMax, GenNode root, GenRulesContext rules, GeneratorSupplier generatorSupplier, GenGraphBuilder graphBuilder) {
        return new GenContext(depthMax, 1, root, rules, generatorSupplier, graphBuilder);
    }

    GeneratorSupplier generatorSupplier() {
        return this.generatorSupplier;
    }

    GenGraphBuilder graphBuilder() {
        return this.graphBuilder;
    }

    GenRulesContext rules() {
        return this.rules;
    }

    int depthMax() {
        return this.depthMax;
    }

    int depthCurrent() {
        return this.depthCurrent;
    }

    GenNode graph() {
        return this.graph;
    }

    public String toString() {
        return this.graph == null ? "[depthMax=" + this.depthMax + ", depthCurrent=" + this.depthCurrent + ']' : "[depthMax=" + this.depthMax + ", depthCurrent=" + this.depthCurrent + ", graph=" + this.graph.value() + ']';
    }
}

