/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.simple.EmbeddedGenerator;
import java.lang.reflect.Field;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

final class GenField {
    private final Field field;
    private final GenType type;
    private final boolean isComplex;
    private final Generator<?> generator;
    @Nullable
    private final Integer depth;

    private GenField(Field field, GenType type, boolean isComplex, Generator<?> generator, Integer depth) {
        this.field = field;
        this.type = type;
        this.isComplex = isComplex;
        this.generator = generator;
        this.depth = depth;
    }

    static GenField ofMarker(Field field, GenType type, Generator<?> generator, boolean isComplex, @Nullable Integer depth) {
        return new GenField(field, type, isComplex, generator, depth);
    }

    static GenField ofRule(Field field, GenType type, Generator<?> generator, boolean isComplex, @Nullable Integer depth) {
        return new GenField(field, type, isComplex, generator, depth);
    }

    static GenField ofAuto(Field field, GenType type, Generator<?> generator, boolean isComplex, Integer depth) {
        return new GenField(field, type, isComplex, generator, depth);
    }

    boolean isEmbedded() {
        return this.generator instanceof EmbeddedGenerator;
    }

    boolean isComplex() {
        return this.isComplex;
    }

    Generator<?> generator() {
        return this.generator;
    }

    String name() {
        return this.field.getName();
    }

    Object getDefaultValue(Object instance) throws IllegalAccessException {
        this.field.setAccessible(true);
        return this.field.get(instance);
    }

    void setValue(Object instance, Object value) throws IllegalAccessException {
        this.field.setAccessible(true);
        this.field.set(instance, value);
    }

    GenType type() {
        return this.type;
    }

    Optional<Integer> depth() {
        return Optional.ofNullable(this.depth);
    }

    public String toString() {
        return "[field=" + this.field.getName() + ", type=" + this.type + ']';
    }
}

