/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.DefaultGenType;
import io.goodforgod.dummymaker.GenField;
import io.goodforgod.dummymaker.GenRuleContext;
import io.goodforgod.dummymaker.GenRulesContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.GeneratorSupplier;
import io.goodforgod.dummymaker.annotation.GenAuto;
import io.goodforgod.dummymaker.annotation.GenCustom;
import io.goodforgod.dummymaker.annotation.GenCustomFactory;
import io.goodforgod.dummymaker.annotation.GenDepth;
import io.goodforgod.dummymaker.annotation.GenIgnore;
import io.goodforgod.dummymaker.generator.AnnotationGeneratorFactory;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.simple.EmbeddedGenerator;
import io.goodforgod.dummymaker.util.CastUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class GenFieldScanner {
    private static final Predicate<Annotation> IS_AUTO = a -> GenAuto.class.equals(a.annotationType());
    private static final Predicate<Annotation> IS_GEN = a -> GenCustom.class.equals(a.annotationType());
    private static final Predicate<Annotation> IS_FACTORY = a -> GenCustomFactory.class.equals(a.annotationType());
    private final GeneratorSupplier generatorSupplier;
    private final GenRulesContext rules;
    private final boolean isAutoByDefault;

    GenFieldScanner(GeneratorSupplier generatorSupplier, GenRulesContext rules, boolean isAutoByDefault) {
        this.generatorSupplier = generatorSupplier;
        this.rules = rules;
        this.isAutoByDefault = isAutoByDefault;
    }

    boolean isEmbedded(@NotNull GenType parent, @NotNull GenType target) {
        Generator generator = this.rules.findClass(parent).flatMap(rule -> rule.find(target)).orElseGet(() -> this.generatorSupplier.get(target.raw()));
        return generator instanceof EmbeddedGenerator;
    }

    @NotNull
    List<GenField> scan(@NotNull GenType target) {
        Class<?> targetType = target.raw();
        List<ScanField> validFields = this.getValidFields(targetType);
        Set ignored = this.rules.findClass(targetType).map(GenRuleContext::getExcludedFields).orElse(Collections.emptySet());
        List fields = validFields.stream().filter(field -> !field.value().isAnnotationPresent(GenIgnore.class)).filter(field -> !ignored.contains(field.value().getName())).collect(Collectors.toList());
        return fields.stream().map(field -> this.convertToGenField(targetType, (ScanField)field).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Optional<GenField> convertToGenField(Class<?> target, ScanField field) {
        boolean isComplex = GenFieldScanner.isComplex(field.type());
        Optional<GenRuleContext> rule = this.rules.findClass(target);
        Integer depth = rule.flatMap(GenRuleContext::getDepth).orElseGet(() -> {
            Integer expectedDepth;
            GenDepth annotation = field.value().getAnnotation(GenDepth.class);
            Integer n = expectedDepth = annotation != null ? Integer.valueOf(annotation.value()) : (Integer)Arrays.stream(target.getDeclaredAnnotations()).filter(a -> a instanceof GenDepth).map(a -> ((GenDepth)a).value()).findFirst().orElse(null);
            if (expectedDepth != null && (expectedDepth < 1 || expectedDepth > 50)) {
                throw new IllegalArgumentException("Depth must be between 1 and 50, but was " + expectedDepth + " for " + target);
            }
            return expectedDepth;
        });
        String fieldName = field.value().getName();
        Class<?> fieldType = field.type().raw();
        Optional ruleGenerator = rule.flatMap(r -> r.find(fieldType, fieldName));
        if (ruleGenerator.isPresent()) {
            return Optional.of(GenField.ofRule(field.value(), field.type(), (Generator)ruleGenerator.get(), isComplex, depth));
        }
        for (Annotation marker : field.value().getDeclaredAnnotations()) {
            Generator<?> generator;
            if (IS_AUTO.test(marker)) {
                generator = this.generatorSupplier.get(fieldType, fieldName);
                return Optional.of(GenField.ofAuto(field.value(), field.type(), generator, isComplex, depth));
            }
            if (IS_GEN.test(marker)) {
                generator = CastUtils.instantiate(((GenCustom)marker).value());
                return Optional.of(GenField.ofMarker(field.value(), field.type(), generator, isComplex, depth));
            }
            for (Annotation custom : marker.annotationType().getDeclaredAnnotations()) {
                if (IS_FACTORY.test(custom)) {
                    AnnotationGeneratorFactory<?> generatorFactory = CastUtils.instantiate(((GenCustomFactory)custom).value());
                    Generator<?> generator2 = generatorFactory.get(marker);
                    return Optional.of(GenField.ofMarker(field.value(), field.type(), generator2, isComplex, depth));
                }
                if (!IS_GEN.test(custom)) continue;
                Generator<?> generator3 = CastUtils.instantiate(((GenCustom)custom).value());
                return Optional.of(GenField.ofMarker(field.value(), field.type(), generator3, isComplex, depth));
            }
        }
        if (rule.flatMap(GenRuleContext::isAuto).orElse(this.isAutoByDefault).booleanValue()) {
            Generator<?> generator = this.generatorSupplier.get(fieldType, fieldName);
            if (generator instanceof EmbeddedGenerator) {
                Generator permittedGenerator = rule.flatMap(r -> r.find(field.type().raw(), fieldName)).orElseGet(() -> this.generatorSupplier.get(field.type().raw(), fieldName));
                return Optional.of(GenField.ofAuto(field.value(), field.type(), permittedGenerator, isComplex, depth));
            }
            return Optional.of(GenField.ofAuto(field.value(), field.type(), generator, isComplex, depth));
        }
        return Optional.empty();
    }

    private static boolean isComplex(GenType type) {
        Class<?> declaringClass = type.raw();
        return Collection.class.isAssignableFrom(declaringClass) || List.class.isAssignableFrom(declaringClass) || Set.class.isAssignableFrom(declaringClass) || Map.class.isAssignableFrom(declaringClass) || declaringClass.getTypeName().endsWith("[][]") || declaringClass.getTypeName().endsWith("[]") || declaringClass.isEnum();
    }

    @NotNull
    private List<ScanField> getValidFields(Type target) {
        if (target == null || Object.class.equals((Object)target)) {
            return Collections.emptyList();
        }
        Class targetClass = target instanceof ParameterizedType ? (Class)((ParameterizedType)target).getRawType() : (Class)target;
        List<ScanField> superFields = this.getValidFields(targetClass.getGenericSuperclass());
        List<ScanField> targetFields = Arrays.stream(targetClass.getDeclaredFields()).filter(f -> !f.isSynthetic()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isNative(f.getModifiers())).filter(f -> !Modifier.isSynchronized(f.getModifiers())).filter(f -> !Modifier.isFinal(f.getModifiers())).flatMap(f -> DefaultGenType.ofType(f.getGenericType()).map(v -> Stream.of(new ScanField((Field)f, (GenType)v))).orElse(Stream.empty())).collect(Collectors.toList());
        if (superFields.isEmpty()) {
            return targetFields;
        }
        superFields.addAll(targetFields);
        return superFields;
    }

    private static class ScanField {
        private final Field value;
        private final GenType type;

        private ScanField(Field value, GenType type) {
            this.value = value;
            this.type = type;
        }

        public Field value() {
            return this.value;
        }

        public GenType type() {
            return this.type;
        }
    }
}

