/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.DefaultGenType;
import io.goodforgod.dummymaker.GenClass;
import io.goodforgod.dummymaker.GenConstructor;
import io.goodforgod.dummymaker.GenConstructorScanner;
import io.goodforgod.dummymaker.GenField;
import io.goodforgod.dummymaker.GenFieldScanner;
import io.goodforgod.dummymaker.GenNode;
import io.goodforgod.dummymaker.GenParameter;
import io.goodforgod.dummymaker.GenRuleContext;
import io.goodforgod.dummymaker.GenRulesContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.annotation.GenDepth;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GenGraphBuilder {
    private final GenRulesContext rules;
    private final GenConstructorScanner constructorScanner;
    private final GenFieldScanner fieldScanner;
    private final int depthByDefault;
    private final boolean ignoreErrors;

    GenGraphBuilder(GenConstructorScanner constructorScanner, GenFieldScanner fieldScanner, GenRulesContext rules, int depthByDefault, boolean ignoreErrors) {
        this.constructorScanner = constructorScanner;
        this.fieldScanner = fieldScanner;
        this.rules = rules;
        this.depthByDefault = depthByDefault;
        this.ignoreErrors = ignoreErrors;
    }

    GenNode build(@NotNull Class<?> target) {
        GenType type = DefaultGenType.ofClass(target);
        Optional<GenRuleContext> rule = this.rules.findClass(target);
        int depth = rule.flatMap(GenRuleContext::getDepth).orElseGet(() -> Arrays.stream(target.getDeclaredAnnotations()).filter(a -> a instanceof GenDepth).map(a -> ((GenDepth)a).value()).findAny().orElse(this.depthByDefault));
        GenClass payload = this.buildPayload(type, null, depth);
        GenNode root = GenNode.ofRoot(payload);
        return this.scanRecursively(root);
    }

    private GenNode scanRecursively(GenNode parent) {
        GenNode genNode;
        HashSet<GenNode> nodesToScan;
        List flattenTypes = parent.value().type().flatten().stream().filter(type -> this.fieldScanner.isEmbedded(parent.value().type(), (GenType)type)).collect(Collectors.toList());
        for (GenType flatType : flattenTypes) {
            List nodes = this.fieldScanner.scan(flatType).stream().filter(field -> field.isEmbedded() || field.isComplex()).flatMap(field -> {
                List<GenType> fieldFlattenTypes = field.type().flatten();
                return Stream.concat(fieldFlattenTypes.stream(), Stream.of(field.type())).distinct().filter(type -> this.fieldScanner.isEmbedded(flatType, (GenType)type)).map(type -> {
                    try {
                        return this.buildPayload((GenType)type, parent.value(), field.depth().orElse(null));
                    }
                    catch (Exception e) {
                        if (this.ignoreErrors) {
                            return null;
                        }
                        throw e;
                    }
                });
            }).map(payload -> GenNode.of(payload, parent)).collect(Collectors.toList());
            nodesToScan = new HashSet<GenNode>();
            for (GenNode node : nodes) {
                Optional<GenNode> nodeAlreadyInGraph = this.find(parent, this.buildFilter(node.value().type()));
                if (nodeAlreadyInGraph.isPresent()) {
                    parent.add(nodeAlreadyInGraph.get());
                    continue;
                }
                parent.add(node);
                nodesToScan.add(node);
            }
            for (GenNode node : nodesToScan) {
                genNode = this.scanRecursively(node);
                parent.add(genNode);
            }
        }
        List parameters = parent.value().constructor().parameters().stream().filter(parameter -> this.fieldScanner.isEmbedded(parent.value().type(), parameter.type())).collect(Collectors.toList());
        for (GenParameter parameter2 : parameters) {
            nodesToScan = new HashSet();
            for (GenType flatParameterType : parameter2.type().flatten()) {
                if (!this.fieldScanner.isEmbedded(parent.value().type(), flatParameterType)) continue;
                try {
                    GenClass payload2 = this.buildPayload(flatParameterType, parent.value(), parent.value().depth());
                    GenNode node = GenNode.of(payload2, parent);
                    Optional<GenNode> nodeAlreadyInGraph = this.find(parent, this.buildFilter(node.value().type()));
                    if (nodeAlreadyInGraph.isPresent()) {
                        parent.add(nodeAlreadyInGraph.get());
                        continue;
                    }
                    parent.add(node);
                    nodesToScan.add(node);
                }
                catch (Exception e) {
                    if (this.ignoreErrors) continue;
                    throw e;
                }
            }
            for (GenNode node : nodesToScan) {
                genNode = this.scanRecursively(node);
                parent.add(genNode);
            }
        }
        return parent;
    }

    private GenClass buildPayload(GenType target, @Nullable GenClass parentPayload, @Nullable Integer depth) {
        Class<?> raw = target.raw().getTypeName().endsWith("[][]") ? target.raw().getComponentType().getComponentType() : (target.raw().getTypeName().endsWith("[]") ? target.raw().getComponentType() : target.raw());
        int payloadDepth = Optional.ofNullable(depth).orElseGet(() -> parentPayload == null ? this.depthByDefault : parentPayload.depth());
        GenType type = DefaultGenType.ofClass(raw);
        List<GenField> fields = this.fieldScanner.scan(type);
        GenConstructor constructor = this.constructorScanner.scan(type);
        return new GenClass(target, payloadDepth, constructor, fields);
    }

    private Optional<GenNode> find(GenNode node, Predicate<GenNode> filter) {
        GenNode root = node.root();
        HashSet<GenNode> visited = new HashSet<GenNode>();
        if (node == root) {
            visited.add(root);
            if (filter.test(root)) {
                return Optional.of(root);
            }
        }
        return this.find(root, filter, visited);
    }

    private Optional<GenNode> find(GenNode rootNode, Predicate<GenNode> filter, Set<GenNode> visited) {
        for (GenNode node : rootNode.nodes()) {
            if (!visited.add(node)) continue;
            if (filter.test(node)) {
                return Optional.of(node);
            }
            GenNode result = this.find(node, filter, visited).orElse(null);
            if (result == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Predicate<GenNode> buildFilter(GenType childType) {
        return node -> node.value().type().equals(childType);
    }
}

