/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenClass;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class GenNode {
    private final GenNode parent;
    private final Set<GenNode> nodes = new HashSet<GenNode>();
    private final GenClass value;
    private final boolean isRoot;

    private GenNode(GenClass value, GenNode parent, boolean isRoot) {
        this.value = value;
        this.parent = parent;
        this.isRoot = isRoot;
    }

    static GenNode ofRoot(GenClass value) {
        return new GenNode(value, null, true);
    }

    static GenNode of(GenClass value, GenNode parent) {
        return new GenNode(value, parent, false);
    }

    GenNode add(GenNode child) {
        this.nodes.add(child);
        return this;
    }

    GenClass value() {
        return this.value;
    }

    GenNode parent() {
        return this.parent;
    }

    Set<GenNode> nodes() {
        return this.nodes;
    }

    GenNode root() {
        return this.isRoot ? this : this.parent.root();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenNode)) {
            return false;
        }
        GenNode genNode = (GenNode)o;
        return Objects.equals(this.value, genNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.parent == null) {
            return "[root=" + this.value.type() + "]";
        }
        return "[value=" + this.value.type() + "]";
    }
}

