/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenRuleField;
import io.goodforgod.dummymaker.generator.Generator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenRule {
    static final Class<?> GLOBAL_MARKER = Void.class;
    private final Integer depth;
    private final Boolean isAuto;
    private final Class<?> target;
    private final Set<String> excludedFields;
    private final Set<GenRuleField> specifiedFields;

    private GenRule(Class<?> target, Boolean isAuto, Integer depth) {
        this.isAuto = isAuto;
        this.target = target;
        this.depth = depth;
        this.excludedFields = new LinkedHashSet<String>();
        this.specifiedFields = new LinkedHashSet<GenRuleField>();
    }

    private GenRule(Integer depth, Boolean isAuto, Class<?> target, Set<String> excludedFields, Set<GenRuleField> specifiedFields) {
        this.depth = depth;
        this.isAuto = isAuto;
        this.target = target;
        this.excludedFields = excludedFields;
        this.specifiedFields = specifiedFields;
    }

    @NotNull
    public static GenRule ofClass(@NotNull Class<?> target) {
        return GenRule.ofClassInner(target, null, null);
    }

    @NotNull
    public static GenRule ofClass(@NotNull Class<?> target, boolean isGenAuto) {
        return GenRule.ofClassInner(target, isGenAuto, null);
    }

    @NotNull
    public static GenRule ofClass(@NotNull Class<?> target, int depth) {
        return GenRule.ofClassInner(target, null, depth);
    }

    @NotNull
    public static GenRule ofClass(@NotNull Class<?> target, boolean isGenAuto, int depth) {
        return GenRule.ofClassInner(target, isGenAuto, depth);
    }

    private static GenRule ofClassInner(@NotNull Class<?> target, @Nullable Boolean isAuto, @Nullable Integer depth) {
        if (GLOBAL_MARKER.equals(target) || Void.TYPE.equals(target)) {
            throw new IllegalArgumentException(GLOBAL_MARKER + " can't be GenRule target class type");
        }
        if (depth != null && (depth < 1 || depth > 50)) {
            throw new IllegalArgumentException("Depth must be between 1 and 50, but was " + depth + " for " + target);
        }
        return new GenRule(target, isAuto, depth);
    }

    @NotNull
    public static GenRule ofGlobal() {
        return new GenRule(GLOBAL_MARKER, null, null);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull String field5, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4, field5), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull String field5, @NotNull String field6, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4, field5, field6), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull String field5, @NotNull String field6, @NotNull String field7, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4, field5, field6, field7), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull String field5, @NotNull String field6, @NotNull String field7, @NotNull String field8, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4, field5, field6, field7, field8), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull String field1, @NotNull String field2, @NotNull String field3, @NotNull String field4, @NotNull String field5, @NotNull String field6, @NotNull String field7, @NotNull String field8, @NotNull String field9, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForNames(Arrays.asList(field1, field2, field3, field4, field5, field6, field7, field8, field9), generatorSupplier);
    }

    @NotNull
    public GenRule generateForNames(@NotNull Collection<String> fieldNames, @NotNull Supplier<Generator<?>> generatorSupplier) {
        for (String fieldName : fieldNames) {
            GenRuleField rule = new GenRuleField(generatorSupplier, fieldName);
            this.specifiedFields.add(rule);
        }
        return this;
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Class<?> type5, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4, type5), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Class<?> type5, @NotNull Class<?> type6, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4, type5, type6), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Class<?> type5, @NotNull Class<?> type6, @NotNull Class<?> type7, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4, type5, type6, type7), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Class<?> type5, @NotNull Class<?> type6, @NotNull Class<?> type7, @NotNull Class<?> type8, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4, type5, type6, type7, type8), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull Class<?> type1, @NotNull Class<?> type2, @NotNull Class<?> type3, @NotNull Class<?> type4, @NotNull Class<?> type5, @NotNull Class<?> type6, @NotNull Class<?> type7, @NotNull Class<?> type8, @NotNull Class<?> type9, @NotNull Supplier<Generator<?>> generatorSupplier) {
        return this.generateForTypes(Arrays.asList(type1, type2, type3, type4, type5, type6, type7, type8, type9), generatorSupplier);
    }

    @NotNull
    public GenRule generateForTypes(@NotNull List<Class<?>> fieldTypes, @NotNull Supplier<Generator<?>> generatorSupplier) {
        for (Class<?> fieldType : fieldTypes) {
            GenRuleField rule = new GenRuleField(generatorSupplier, fieldType);
            this.specifiedFields.add(rule);
        }
        return this;
    }

    @NotNull
    public GenRule excludeFields(String ... fieldNames) {
        this.excludedFields.addAll(Arrays.asList(fieldNames));
        return this;
    }

    GenRule build() {
        return new GenRule(this.depth, this.isAuto, this.target, Collections.unmodifiableSet(this.excludedFields), Collections.unmodifiableSet(this.specifiedFields));
    }

    GenRule merge(GenRule rule) {
        if (this.getTarget().equals(rule.getTarget()) || rule.isGlobal()) {
            this.specifiedFields.addAll(rule.specifiedFields);
            this.excludedFields.addAll(rule.excludedFields);
        }
        return this;
    }

    boolean isGlobal() {
        return GLOBAL_MARKER.equals(this.target);
    }

    Optional<Integer> getDepth() {
        return Optional.ofNullable(this.depth);
    }

    Optional<Boolean> isAuto() {
        return Optional.ofNullable(this.isAuto);
    }

    Class<?> getTarget() {
        return this.target;
    }

    Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    Set<GenRuleField> getSpecifiedFields() {
        return this.specifiedFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenRule)) {
            return false;
        }
        GenRule genRule = (GenRule)o;
        return Objects.equals(this.target, genRule.target);
    }

    public int hashCode() {
        return Objects.hash(this.target);
    }

    public String toString() {
        return "[type=" + this.target + ']';
    }
}

