/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenRule;
import io.goodforgod.dummymaker.GenRuleField;
import io.goodforgod.dummymaker.GenRuleFieldContext;
import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.generator.Generator;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class GenRuleContext {
    private final Integer depth;
    private final Boolean isAuto;
    private final Class<?> target;
    private final Set<String> excludedFields;
    private final Set<GenRuleFieldContext> specifiedFields;

    GenRuleContext(GenRule rule) {
        this.depth = rule.getDepth().orElse(null);
        this.isAuto = rule.isAuto().orElse(null);
        this.target = rule.getTarget();
        this.excludedFields = rule.getExcludedFields();
        IdentityHashMap generatorMap = new IdentityHashMap();
        this.specifiedFields = rule.getSpecifiedFields().stream().map(ruleField -> new GenRuleFieldContext((GenRuleField)ruleField, generatorMap)).collect(Collectors.toSet());
    }

    Optional<Generator<?>> find(@NotNull Class<?> type, @NotNull String fieldName) {
        if (this.isExcluded(fieldName)) {
            return Optional.empty();
        }
        Optional<Generator<?>> namedGenerator = this.specifiedFields.stream().filter(rule -> fieldName.equals(rule.getName())).findFirst().map(GenRuleFieldContext::getGenerator);
        if (namedGenerator.isPresent()) {
            return namedGenerator;
        }
        return this.find(type);
    }

    Optional<Generator<?>> find(GenType type) {
        return this.find(type.raw());
    }

    Optional<Generator<?>> find(Class<?> type) {
        if (type == null) {
            return Optional.empty();
        }
        Optional<Generator> equalGenerator = this.specifiedFields.stream().filter(GenRuleFieldContext::isTyped).filter(rule -> type.equals(rule.getType())).findFirst().map(GenRuleFieldContext::getGenerator);
        if (equalGenerator.isPresent()) {
            return Optional.of(equalGenerator.get());
        }
        return this.specifiedFields.stream().filter(GenRuleFieldContext::isTyped).filter(rule -> rule.getType().isAssignableFrom(type)).findFirst().map(GenRuleFieldContext::getGenerator);
    }

    boolean isGlobal() {
        return GenRule.GLOBAL_MARKER.equals(this.target);
    }

    boolean isExcluded(String fieldName) {
        return this.excludedFields.contains(fieldName);
    }

    Optional<Integer> getDepth() {
        return Optional.ofNullable(this.depth);
    }

    Optional<Boolean> isAuto() {
        return Optional.ofNullable(this.isAuto);
    }

    Class<?> getTarget() {
        return this.target;
    }

    Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    Set<GenRuleFieldContext> getSpecifiedFields() {
        return this.specifiedFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenRuleContext)) {
            return false;
        }
        GenRuleContext genRule = (GenRuleContext)o;
        return Objects.equals(this.depth, genRule.depth) && Objects.equals(this.isAuto, genRule.isAuto) && Objects.equals(this.target, genRule.target) && Objects.equals(this.excludedFields, genRule.excludedFields) && Objects.equals(this.specifiedFields, genRule.specifiedFields);
    }

    public int hashCode() {
        return Objects.hash(this.depth, this.isAuto, this.target, this.excludedFields, this.specifiedFields);
    }

    public String toString() {
        return "[type=" + this.target + ']';
    }
}

