/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenRuleField;
import io.goodforgod.dummymaker.generator.Generator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

final class GenRuleFieldContext {
    private final Class<?> type;
    private final String name;
    private final Generator<?> generator;

    GenRuleFieldContext(GenRuleField ruleField, Map<Supplier<Generator<?>>, Generator<?>> generatorMap) {
        this.type = ruleField.getType();
        this.name = ruleField.getName();
        this.generator = generatorMap.computeIfAbsent(ruleField.getGeneratorSupplier(), Supplier::get);
    }

    boolean isTyped() {
        return this.type != null;
    }

    Class<?> getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    Generator<?> getGenerator() {
        return this.generator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenRuleFieldContext)) {
            return false;
        }
        GenRuleFieldContext that = (GenRuleFieldContext)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        if (this.type != null) {
            return "[type=" + this.type + ']';
        }
        return "[name=" + this.name + ']';
    }
}

