/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenRule;
import io.goodforgod.dummymaker.GenRulesContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class GenRules {
    static final GenRules EMPTY = new GenRules(Collections.emptyList());
    private final List<GenRule> rules;

    private GenRules(List<GenRule> rules) {
        this.rules = rules;
    }

    @NotNull
    static GenRules of(@NotNull List<GenRule> rules) {
        Map<Class, List<GenRule>> collected = rules.stream().collect(Collectors.groupingBy(GenRule::getTarget));
        Optional<GenRule> global = rules.stream().filter(GenRule::isGlobal).findFirst();
        List<GenRule> genRules = collected.values().stream().map(r -> r.stream().reduce(GenRule::merge).map(rule -> global.map(rule::merge).orElse((GenRule)rule)).orElse(null)).filter(Objects::nonNull).map(GenRule::build).collect(Collectors.toList());
        return new GenRules(genRules);
    }

    List<GenRule> rules() {
        return this.rules;
    }

    GenRulesContext context() {
        return new GenRulesContext(this);
    }
}

