/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.GenRuleContext;
import io.goodforgod.dummymaker.GenRules;
import io.goodforgod.dummymaker.GenType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class GenRulesContext {
    private final List<GenRuleContext> rules;

    GenRulesContext(GenRules rules) {
        this.rules = rules.rules().stream().map(GenRuleContext::new).collect(Collectors.toList());
    }

    Optional<GenRuleContext> findClass(@NotNull GenType target) {
        return this.findClass(target.raw());
    }

    Optional<GenRuleContext> findClass(@NotNull Class<?> target) {
        return Optional.ofNullable(this.rules.stream().filter(rule -> target.equals(rule.getTarget())).findFirst().orElseGet(() -> this.rules.stream().filter(rule -> rule.getTarget().isAssignableFrom(target)).findFirst().orElseGet(() -> this.findGlobal().orElse(null))));
    }

    Optional<GenRuleContext> findGlobal() {
        return this.rules.stream().filter(GenRuleContext::isGlobal).findFirst();
    }
}

