/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker;

import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.parameterized.Array2DParameterizedGenerator;
import io.goodforgod.dummymaker.generator.parameterized.ArrayParameterizedGenerator;
import io.goodforgod.dummymaker.generator.parameterized.EnumParameterizedGenerator;
import io.goodforgod.dummymaker.generator.parameterized.ListParameterizedGenerator;
import io.goodforgod.dummymaker.generator.parameterized.MapParameterizedGenerator;
import io.goodforgod.dummymaker.generator.parameterized.SetParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.BooleanGenerator;
import io.goodforgod.dummymaker.generator.simple.EmbeddedGenerator;
import io.goodforgod.dummymaker.generator.simple.NullGenerator;
import io.goodforgod.dummymaker.generator.simple.ObjectGenerator;
import io.goodforgod.dummymaker.generator.simple.UriGenerator;
import io.goodforgod.dummymaker.generator.simple.UrlGenerator;
import io.goodforgod.dummymaker.generator.simple.UuidGenerator;
import io.goodforgod.dummymaker.generator.simple.number.BigDecimalGenerator;
import io.goodforgod.dummymaker.generator.simple.number.BigIntegerGenerator;
import io.goodforgod.dummymaker.generator.simple.number.ByteGenerator;
import io.goodforgod.dummymaker.generator.simple.number.CharGenerator;
import io.goodforgod.dummymaker.generator.simple.number.CharacterGenerator;
import io.goodforgod.dummymaker.generator.simple.number.DoubleSmallGenerator;
import io.goodforgod.dummymaker.generator.simple.number.FloatSmallGenerator;
import io.goodforgod.dummymaker.generator.simple.number.IntegerGenerator;
import io.goodforgod.dummymaker.generator.simple.number.IntegerSmallGenerator;
import io.goodforgod.dummymaker.generator.simple.number.LongGenerator;
import io.goodforgod.dummymaker.generator.simple.number.MccGenerator;
import io.goodforgod.dummymaker.generator.simple.number.PostalGenerator;
import io.goodforgod.dummymaker.generator.simple.number.PriceGenerator;
import io.goodforgod.dummymaker.generator.simple.number.ShortGenerator;
import io.goodforgod.dummymaker.generator.simple.number.UnixTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.string.AddressFullGenerator;
import io.goodforgod.dummymaker.generator.simple.string.AddressGenerator;
import io.goodforgod.dummymaker.generator.simple.string.BtcAddressGenerator;
import io.goodforgod.dummymaker.generator.simple.string.BtcTxHashGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CadastralGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CategoryGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CityGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CompanyGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CountryGenerator;
import io.goodforgod.dummymaker.generator.simple.string.CurrencyGenerator;
import io.goodforgod.dummymaker.generator.simple.string.DescriptionGenerator;
import io.goodforgod.dummymaker.generator.simple.string.DistrictGenerator;
import io.goodforgod.dummymaker.generator.simple.string.DocumentGenerator;
import io.goodforgod.dummymaker.generator.simple.string.EmailGenerator;
import io.goodforgod.dummymaker.generator.simple.string.EthAddressGenerator;
import io.goodforgod.dummymaker.generator.simple.string.EthTxHashGenerator;
import io.goodforgod.dummymaker.generator.simple.string.ExtensionGenerator;
import io.goodforgod.dummymaker.generator.simple.string.FileGenerator;
import io.goodforgod.dummymaker.generator.simple.string.FormatGenerator;
import io.goodforgod.dummymaker.generator.simple.string.FrequencyGenerator;
import io.goodforgod.dummymaker.generator.simple.string.FullnameGenerator;
import io.goodforgod.dummymaker.generator.simple.string.GenderGenerator;
import io.goodforgod.dummymaker.generator.simple.string.HexDataGenerator;
import io.goodforgod.dummymaker.generator.simple.string.HexNumberGenerator;
import io.goodforgod.dummymaker.generator.simple.string.HouseGenerator;
import io.goodforgod.dummymaker.generator.simple.string.IPv4Generator;
import io.goodforgod.dummymaker.generator.simple.string.IPv6Generator;
import io.goodforgod.dummymaker.generator.simple.string.IdBigGenerator;
import io.goodforgod.dummymaker.generator.simple.string.IdGenerator;
import io.goodforgod.dummymaker.generator.simple.string.JobGenerator;
import io.goodforgod.dummymaker.generator.simple.string.LevelGenerator;
import io.goodforgod.dummymaker.generator.simple.string.LoginGenerator;
import io.goodforgod.dummymaker.generator.simple.string.MerchantGenerator;
import io.goodforgod.dummymaker.generator.simple.string.MiddleNameGenerator;
import io.goodforgod.dummymaker.generator.simple.string.NameGenerator;
import io.goodforgod.dummymaker.generator.simple.string.NounGenerator;
import io.goodforgod.dummymaker.generator.simple.string.PasswordGenerator;
import io.goodforgod.dummymaker.generator.simple.string.PhoneGenerator;
import io.goodforgod.dummymaker.generator.simple.string.PhotoGenerator;
import io.goodforgod.dummymaker.generator.simple.string.ProductGenerator;
import io.goodforgod.dummymaker.generator.simple.string.RoleGenerator;
import io.goodforgod.dummymaker.generator.simple.string.StatusGenerator;
import io.goodforgod.dummymaker.generator.simple.string.StreetGenerator;
import io.goodforgod.dummymaker.generator.simple.string.StringGenerator;
import io.goodforgod.dummymaker.generator.simple.string.SurnameGenerator;
import io.goodforgod.dummymaker.generator.simple.string.TagGenerator;
import io.goodforgod.dummymaker.generator.simple.string.TypeGenerator;
import io.goodforgod.dummymaker.generator.simple.string.VersionGenerator;
import io.goodforgod.dummymaker.generator.simple.time.CalendarGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DateGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DateSqlGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DayOfWeekGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DurationGenerator;
import io.goodforgod.dummymaker.generator.simple.time.InstantGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalDateGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.MonthDayGenerator;
import io.goodforgod.dummymaker.generator.simple.time.MonthGenerator;
import io.goodforgod.dummymaker.generator.simple.time.OffsetDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.OffsetTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.PeriodGenerator;
import io.goodforgod.dummymaker.generator.simple.time.TimeSqlGenerator;
import io.goodforgod.dummymaker.generator.simple.time.TimestampGenerator;
import io.goodforgod.dummymaker.generator.simple.time.YearGenerator;
import io.goodforgod.dummymaker.generator.simple.time.YearMonthGenerator;
import io.goodforgod.dummymaker.generator.simple.time.ZonedDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.ZonedOffsetGenerator;
import io.goodforgod.dummymaker.util.CastUtils;
import io.goodforgod.dummymaker.util.CollectionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

final class GeneratorSupplier {
    private static final Generator<?> DEFAULT_GENERATOR = new EmbeddedGenerator();
    private static final Generator<?> ARRAY2D_GENERATOR = new Array2DParameterizedGenerator(1, 3, 1, 3);
    private static final Generator<?> ARRAY_GENERATOR = new ArrayParameterizedGenerator(1, 3);
    private static final Generator<?> ENUM_GENERATOR = new EnumParameterizedGenerator(new String[0], new String[0]);
    private static final Map<Class<?>, List<Generator<?>>> TYPE_TO_GENERATORS = new HashMap();
    private final long seed;

    GeneratorSupplier(long seed) {
        this.seed = seed;
    }

    @NotNull
    Generator<?> get(@NotNull Class<?> type) {
        if (type.getTypeName().endsWith("[][]")) {
            return ARRAY2D_GENERATOR;
        }
        if (type.getTypeName().endsWith("[]")) {
            return ARRAY_GENERATOR;
        }
        if (type.isEnum()) {
            return ENUM_GENERATOR;
        }
        List<Generator<?>> generators = TYPE_TO_GENERATORS.get(type);
        if (generators == null) {
            return DEFAULT_GENERATOR;
        }
        return CollectionUtils.getIndexWithSalt(generators, "null", this.seed);
    }

    @NotNull
    Generator<?> get(@NotNull Class<?> type, @NotNull String fieldName) {
        if (type.getTypeName().endsWith("[][]")) {
            return ARRAY2D_GENERATOR;
        }
        if (type.getTypeName().endsWith("[]")) {
            return ARRAY_GENERATOR;
        }
        if (type.isEnum()) {
            return ENUM_GENERATOR;
        }
        return TYPE_TO_GENERATORS.values().stream().flatMap(Collection::stream).filter(g -> g.hints().pattern() != null && g.hints().pattern().matcher(fieldName).find()).sorted((g1, g2) -> Integer.compare(g2.hints().priority(), g1.hints().priority())).filter(g -> CastUtils.castObject(g.get(), type) != null).findFirst().orElseGet(() -> this.getRandomGenerator(type, fieldName));
    }

    private Generator<?> getRandomGenerator(Class<?> type, String fieldName) {
        List<Generator<?>> generators = TYPE_TO_GENERATORS.get(type);
        if (generators == null) {
            return DEFAULT_GENERATOR;
        }
        return CollectionUtils.getIndexWithSalt(generators, fieldName, this.seed);
    }

    static {
        TYPE_TO_GENERATORS.put(String.class, Arrays.asList(new AddressFullGenerator(), new AddressGenerator(), new BtcAddressGenerator(), new BtcTxHashGenerator(), new CadastralGenerator(), new CategoryGenerator(), new CityGenerator(), new CompanyGenerator(), new CountryGenerator(), new CurrencyGenerator(), new DescriptionGenerator(), new DistrictGenerator(), new DocumentGenerator(), new EmailGenerator(), new EthAddressGenerator(), new EthTxHashGenerator(), new ExtensionGenerator(), new FileGenerator(), new FormatGenerator(), new FrequencyGenerator(), new FullnameGenerator(), new GenderGenerator(), new HexDataGenerator(), new HexNumberGenerator(), new HouseGenerator(), new IdBigGenerator(), new IdGenerator(), new JobGenerator(), new LevelGenerator(), new LoginGenerator(), new MccGenerator(), new MerchantGenerator(), new MiddleNameGenerator(), new NameGenerator(), new NounGenerator(), new PasswordGenerator(), new PhoneGenerator(false), new PhotoGenerator(), new ProductGenerator(), new RoleGenerator(), new StatusGenerator(), new StreetGenerator(), new StringGenerator(), new SurnameGenerator(), new TagGenerator(), new TypeGenerator(), new VersionGenerator(), new IPv4Generator(), new IPv6Generator()));
        TYPE_TO_GENERATORS.put(CharSequence.class, TYPE_TO_GENERATORS.get(String.class));
        TYPE_TO_GENERATORS.put(Void.TYPE, Collections.singletonList(new NullGenerator()));
        TYPE_TO_GENERATORS.put(Void.class, Collections.singletonList(new NullGenerator()));
        TYPE_TO_GENERATORS.put(Object.class, Collections.singletonList(new ObjectGenerator()));
        TYPE_TO_GENERATORS.put(Boolean.class, Collections.singletonList(new BooleanGenerator()));
        TYPE_TO_GENERATORS.put(Byte.class, Collections.singletonList(new ByteGenerator()));
        TYPE_TO_GENERATORS.put(Character.class, Arrays.asList(new CharacterGenerator(), new CharGenerator()));
        TYPE_TO_GENERATORS.put(Short.class, Collections.singletonList(new ShortGenerator()));
        TYPE_TO_GENERATORS.put(Integer.class, Arrays.asList(new IntegerGenerator(), new IntegerSmallGenerator(), new PostalGenerator(), new MccGenerator()));
        TYPE_TO_GENERATORS.put(Long.class, Arrays.asList(new LongGenerator(), new UnixTimeGenerator()));
        TYPE_TO_GENERATORS.put(Float.class, Collections.singletonList(new FloatSmallGenerator()));
        TYPE_TO_GENERATORS.put(Double.class, Collections.singletonList(new DoubleSmallGenerator()));
        TYPE_TO_GENERATORS.put(BigInteger.class, Collections.singletonList(new BigIntegerGenerator()));
        TYPE_TO_GENERATORS.put(BigDecimal.class, Arrays.asList(new BigDecimalGenerator(), new PriceGenerator()));
        TYPE_TO_GENERATORS.put(Boolean.TYPE, TYPE_TO_GENERATORS.get(Boolean.class));
        TYPE_TO_GENERATORS.put(Byte.TYPE, TYPE_TO_GENERATORS.get(Byte.class));
        TYPE_TO_GENERATORS.put(Short.TYPE, TYPE_TO_GENERATORS.get(Short.class));
        TYPE_TO_GENERATORS.put(Character.TYPE, TYPE_TO_GENERATORS.get(Character.class));
        TYPE_TO_GENERATORS.put(Integer.TYPE, TYPE_TO_GENERATORS.get(Integer.class));
        TYPE_TO_GENERATORS.put(Long.TYPE, TYPE_TO_GENERATORS.get(Long.class));
        TYPE_TO_GENERATORS.put(Float.TYPE, TYPE_TO_GENERATORS.get(Float.class));
        TYPE_TO_GENERATORS.put(Double.TYPE, TYPE_TO_GENERATORS.get(Double.class));
        TYPE_TO_GENERATORS.put(Calendar.class, Collections.singletonList(new CalendarGenerator()));
        TYPE_TO_GENERATORS.put(Period.class, Collections.singletonList(new PeriodGenerator()));
        TYPE_TO_GENERATORS.put(Duration.class, Collections.singletonList(new DurationGenerator()));
        TYPE_TO_GENERATORS.put(Time.class, Collections.singletonList(new TimeSqlGenerator()));
        TYPE_TO_GENERATORS.put(Timestamp.class, Collections.singletonList(new TimestampGenerator()));
        TYPE_TO_GENERATORS.put(Date.class, Collections.singletonList(new DateGenerator()));
        TYPE_TO_GENERATORS.put(java.sql.Date.class, Collections.singletonList(new DateSqlGenerator()));
        TYPE_TO_GENERATORS.put(Instant.class, Collections.singletonList(new InstantGenerator()));
        TYPE_TO_GENERATORS.put(LocalTime.class, Collections.singletonList(new LocalTimeGenerator()));
        TYPE_TO_GENERATORS.put(LocalDate.class, Collections.singletonList(new LocalDateGenerator()));
        TYPE_TO_GENERATORS.put(LocalDateTime.class, Collections.singletonList(new LocalDateTimeGenerator()));
        TYPE_TO_GENERATORS.put(OffsetTime.class, Collections.singletonList(new OffsetTimeGenerator()));
        TYPE_TO_GENERATORS.put(OffsetDateTime.class, Collections.singletonList(new OffsetDateTimeGenerator()));
        TYPE_TO_GENERATORS.put(ZoneOffset.class, Collections.singletonList(new ZonedOffsetGenerator()));
        TYPE_TO_GENERATORS.put(ZonedDateTime.class, Collections.singletonList(new ZonedDateTimeGenerator()));
        TYPE_TO_GENERATORS.put(DayOfWeek.class, Collections.singletonList(new DayOfWeekGenerator()));
        TYPE_TO_GENERATORS.put(Month.class, Collections.singletonList(new MonthGenerator()));
        TYPE_TO_GENERATORS.put(MonthDay.class, Collections.singletonList(new MonthDayGenerator()));
        TYPE_TO_GENERATORS.put(Year.class, Collections.singletonList(new YearGenerator()));
        TYPE_TO_GENERATORS.put(YearMonth.class, Collections.singletonList(new YearMonthGenerator()));
        TYPE_TO_GENERATORS.put(URI.class, Collections.singletonList(new UriGenerator()));
        TYPE_TO_GENERATORS.put(URL.class, Collections.singletonList(new UrlGenerator()));
        TYPE_TO_GENERATORS.put(UUID.class, Collections.singletonList(new UuidGenerator()));
        ListParameterizedGenerator listGenerator = new ListParameterizedGenerator(1, 3);
        List<ListParameterizedGenerator> listComplexGenerators = Collections.singletonList(listGenerator);
        TYPE_TO_GENERATORS.put(Collection.class, listComplexGenerators);
        TYPE_TO_GENERATORS.put(List.class, listComplexGenerators);
        TYPE_TO_GENERATORS.put(ArrayList.class, listComplexGenerators);
        TYPE_TO_GENERATORS.put(LinkedList.class, listComplexGenerators);
        TYPE_TO_GENERATORS.put(CopyOnWriteArrayList.class, listComplexGenerators);
        SetParameterizedGenerator setGenerator = new SetParameterizedGenerator(1, 3);
        List<SetParameterizedGenerator> setComplexGenerators = Collections.singletonList(setGenerator);
        TYPE_TO_GENERATORS.put(Set.class, setComplexGenerators);
        TYPE_TO_GENERATORS.put(HashSet.class, setComplexGenerators);
        TYPE_TO_GENERATORS.put(ConcurrentSkipListSet.class, setComplexGenerators);
        TYPE_TO_GENERATORS.put(CopyOnWriteArraySet.class, setComplexGenerators);
        MapParameterizedGenerator mapGenerator = new MapParameterizedGenerator(1, 3);
        List<MapParameterizedGenerator> mapComplexGenerators = Collections.singletonList(mapGenerator);
        TYPE_TO_GENERATORS.put(Map.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(TreeMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(HashMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(WeakHashMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(IdentityHashMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(ConcurrentHashMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(ConcurrentSkipListMap.class, mapComplexGenerators);
        TYPE_TO_GENERATORS.put(Enumeration.class, Collections.singletonList(ENUM_GENERATOR));
    }
}

