/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.error.GenExportException;
import io.goodforgod.dummymaker.export.DateExportField;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.ExportScanner;
import io.goodforgod.dummymaker.export.Exporter;
import io.goodforgod.dummymaker.export.Writer;
import io.goodforgod.dummymaker.util.CollectionUtils;
import io.goodforgod.dummymaker.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

abstract class AbstractExporter
implements Exporter {
    private static final String DEFAULT_EMPTY_VALUE = "";
    protected final ExportScanner scanner;
    protected final NamingCase fieldNamingCase;
    protected final Function<String, Writer> writerFunction;

    AbstractExporter(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase fieldNamingCase, Function<String, Writer> writerFunction) {
        this.fieldNamingCase = fieldNamingCase;
        this.writerFunction = writerFunction;
        this.scanner = new ExportScanner(fieldsInclude, fieldsExclude, fieldNamingCase);
    }

    @NotNull
    protected abstract String getExtension();

    @NotNull
    protected abstract <T> String map(T var1, Collection<ExportField> var2);

    protected Predicate<ExportField> filter() {
        return c -> true;
    }

    protected Stream<ExportField> scan(Class<?> type) {
        return this.scan(type, this.filter());
    }

    protected Stream<ExportField> scan(Class<?> type, Predicate<ExportField> filter) {
        return this.scanner.scan(type).stream().filter(filter);
    }

    @NotNull
    protected <T> String getValue(T t, ExportField container) {
        if (t == null) {
            return DEFAULT_EMPTY_VALUE;
        }
        try {
            Field field = container.getField();
            field.setAccessible(true);
            Object value = field.get(t);
            if (value == null) {
                return this.convertNull();
            }
            switch (container.getType()) {
                case BOOLEAN: {
                    return this.convertBoolean((Boolean)value);
                }
                case NUMBER: {
                    return this.convertNumber(value);
                }
                case STRING: {
                    return this.convertString(String.valueOf(value));
                }
                case DATE: {
                    return this.convertDate(value, (DateExportField)container);
                }
                case ARRAY: {
                    return this.convertArray(value);
                }
                case ARRAY_2D: {
                    return this.convertArray2D(value);
                }
                case MAP: {
                    return this.convertMap((Map)value);
                }
                case COLLECTION: {
                    return this.convertCollection((Collection)value);
                }
            }
            return this.convertComplex(value);
        }
        catch (Exception ex) {
            throw new GenExportException("Error occurred while value conversion due to: ", ex);
        }
    }

    protected String convertNull() {
        return DEFAULT_EMPTY_VALUE;
    }

    protected String convertBoolean(Boolean bool) {
        return bool.toString();
    }

    protected String convertString(String s) {
        return s;
    }

    protected String convertNumber(Object number) {
        return String.valueOf(number);
    }

    protected String convertDate(Object date, DateExportField dateExportField) {
        return dateExportField.getFormatted(date);
    }

    protected String convertArray(Object array) {
        Class<?> type = array.getClass().getComponentType();
        if (type == Byte.TYPE) {
            return Arrays.toString((byte[])array);
        }
        if (type == Short.TYPE) {
            return Arrays.toString((short[])array);
        }
        if (type == Integer.TYPE) {
            return Arrays.toString((int[])array);
        }
        if (type == Long.TYPE) {
            return Arrays.toString((long[])array);
        }
        if (type == Float.TYPE) {
            return Arrays.toString((float[])array);
        }
        if (type == Double.TYPE) {
            return Arrays.toString((double[])array);
        }
        if (type == Boolean.TYPE) {
            return Arrays.toString((boolean[])array);
        }
        if (type == Character.TYPE) {
            return Arrays.toString((char[])array);
        }
        return Arrays.stream((Object[])array).map(v -> this.convertString(String.valueOf(v))).collect(Collectors.joining(",", "[", "]"));
    }

    protected String convertArray2D(Object array) {
        return Arrays.deepToString((Object[])array);
    }

    protected String convertCollection(Collection<?> collection) {
        return collection.stream().map(v -> this.convertString(String.valueOf(v))).collect(Collectors.joining(",", "[", "]"));
    }

    protected String convertMap(Map<?, ?> map) {
        return map.entrySet().stream().map(e -> {
            String key = this.convertString(String.valueOf(e.getKey()));
            String value = this.convertString(String.valueOf(e.getValue()));
            return key + ":" + value;
        }).collect(Collectors.joining(",", "{", "}"));
    }

    protected String convertComplex(Object object) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected <T> String prefix(Class<T> type, Collection<ExportField> containers) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected <T> String suffix(Class<T> type, Collection<ExportField> containers) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected <T> String separator(Class<T> type, Collection<ExportField> containers) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected <T> String head(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected <T> String tail(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        return DEFAULT_EMPTY_VALUE;
    }

    @NotNull
    protected Writer getWriter(String filename) {
        return this.writerFunction.apply(filename + "." + this.getExtension());
    }

    @Override
    public void exportAsFile(Object value) {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        Collection containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return;
        }
        try (Writer writer = this.getWriter(type.getSimpleName());){
            String head = this.head(type, containers, false);
            String data = this.prefix(type, containers) + this.map(value, containers) + this.suffix(type, containers);
            String tail = this.tail(type, containers, false);
            writer.write(head + data + tail);
        }
        catch (Exception e) {
            throw new GenExportException("Error occurred while exporting due to: ", e);
        }
    }

    @Override
    public void exportAsFile(@NotNull Collection<?> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Object firstValue = collection.iterator().next();
        Collection containers = this.scan(firstValue.getClass()).collect(Collectors.toList());
        try (Writer writer = this.getWriter(firstValue.getClass().getSimpleName());){
            String head = this.head(firstValue.getClass(), containers, true);
            writer.write(head);
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String valueAsString;
                Object value = iterator.next();
                if (value == null || !StringUtils.isNotBlank(valueAsString = this.map(value, containers))) continue;
                String result = this.prefix(firstValue.getClass(), containers) + valueAsString + this.suffix(firstValue.getClass(), containers);
                if (iterator.hasNext()) {
                    String separator = this.separator(firstValue.getClass(), containers);
                    writer.write(result + separator);
                    continue;
                }
                writer.write(result);
            }
            String tail = this.tail(firstValue.getClass(), containers, true);
            writer.write(tail);
        }
        catch (Exception e) {
            throw new GenExportException("Error occurred while exporting due to: ", e);
        }
    }

    @Override
    public <T> void streamToFile(@NotNull Stream<T> stream, Class<T> type) {
        Collection containers = this.scan(type).collect(Collectors.toList());
        AtomicReference firstValueRef = new AtomicReference();
        try (Writer writer = this.getWriter(type.getSimpleName());){
            stream.filter(Objects::nonNull).forEach(value -> {
                String valueAsString;
                boolean isFirst = false;
                if (firstValueRef.get() == null) {
                    AtomicReference atomicReference = firstValueRef;
                    synchronized (atomicReference) {
                        if (firstValueRef.get() == null) {
                            String head = this.head(type, containers, true);
                            writer.write(head);
                            isFirst = true;
                            firstValueRef.set(value);
                        }
                    }
                }
                if (StringUtils.isNotBlank(valueAsString = this.map(value, containers))) {
                    String result = this.prefix(type, containers) + valueAsString + this.suffix(type, containers);
                    String separator = this.separator(type, containers);
                    if (isFirst) {
                        writer.write(result);
                    } else {
                        writer.write(separator + result);
                    }
                }
            });
            if (firstValueRef.get() != null) {
                String tail = this.tail(type, containers, true);
                writer.write(tail);
            }
        }
        catch (Exception e) {
            throw new GenExportException("Error occurred while exporting due to: ", e);
        }
    }

    @Override
    @NotNull
    public String exportAsString(Object value) {
        if (value == null) {
            return DEFAULT_EMPTY_VALUE;
        }
        Class<?> type = value.getClass();
        Collection containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return DEFAULT_EMPTY_VALUE;
        }
        String head = this.head(type, containers, false);
        String data = this.prefix(type, containers) + this.map(value, containers) + this.suffix(type, containers);
        String tail = this.tail(type, containers, false);
        return head + data + tail;
    }

    @Override
    @NotNull
    public String exportAsString(@NotNull Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return DEFAULT_EMPTY_VALUE;
        }
        Object firstValue = collection.iterator().next();
        Class<?> type = firstValue.getClass();
        Collection containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return DEFAULT_EMPTY_VALUE;
        }
        String head = this.head(type, containers, true);
        String data = this.convertData(type, collection, containers);
        String tail = this.tail(type, containers, true);
        return head + data + tail;
    }

    @Override
    @NotNull
    public <T> String streamToString(@NotNull Stream<T> stream, Class<T> type) {
        Collection containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return DEFAULT_EMPTY_VALUE;
        }
        AtomicReference firstValueRef = new AtomicReference();
        return stream.filter(Objects::nonNull).map(value -> {
            String valueAsString;
            if (firstValueRef.get() == null) {
                AtomicReference atomicReference = firstValueRef;
                synchronized (atomicReference) {
                    if (firstValueRef.get() == null) {
                        firstValueRef.set(value);
                    }
                }
            }
            if (StringUtils.isBlank(valueAsString = this.map(value, containers))) {
                return DEFAULT_EMPTY_VALUE;
            }
            return this.prefix(type, containers) + valueAsString + this.suffix(type, containers);
        }).collect(Collectors.joining(this.separator(type, containers), this.head(type, containers, true), this.tail(type, containers, true)));
    }

    protected String convertData(Class<?> type, Collection<?> collection, Collection<ExportField> containers) {
        return collection.stream().filter(Objects::nonNull).map(value -> {
            String valueAsString = this.map(value, containers);
            return StringUtils.isEmpty(valueAsString) ? DEFAULT_EMPTY_VALUE : this.prefix(type, containers) + valueAsString + this.suffix(type, containers);
        }).filter(StringUtils::isNotEmpty).collect(Collectors.joining(this.separator(type, containers)));
    }
}

