/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.export.AbstractExporter;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.SimpleFileWriter;
import io.goodforgod.dummymaker.export.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CsvExporter
extends AbstractExporter {
    private static final char DEFAULT_SEPARATOR = ',';
    private final String separator;
    private final boolean hasHeader;

    private CsvExporter(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase fieldNamingCase, Function<String, Writer> writerFunction, boolean hasHeader, String separator) {
        super(fieldsInclude, fieldsExclude, fieldNamingCase, writerFunction);
        this.hasHeader = hasHeader;
        this.separator = separator;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static CsvExporter build() {
        return new Builder().build();
    }

    @Override
    @NotNull
    protected String getExtension() {
        return "csv";
    }

    @Override
    protected Predicate<ExportField> filter() {
        return c -> c.getType() == ExportField.Type.STRING || c.getType() == ExportField.Type.BOOLEAN || c.getType() == ExportField.Type.NUMBER || c.getType() == ExportField.Type.DATE;
    }

    @Override
    @NotNull
    protected <T> String head(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        if (!this.hasHeader) {
            return "";
        }
        return containers.stream().map(ExportField::getName).collect(Collectors.joining(this.separator, "", "\n"));
    }

    @Override
    @NotNull
    protected <T> String map(T value, Collection<ExportField> containers) {
        return containers.stream().map(c -> this.getValue(value, (ExportField)c)).collect(Collectors.joining(this.separator));
    }

    @Override
    @NotNull
    protected <T> String separator(Class<T> type, Collection<ExportField> containers) {
        return "\n";
    }

    public static final class Builder {
        private final Set<String> fieldsInclude = new HashSet<String>();
        private final Set<String> fieldsExclude = new HashSet<String>();
        private NamingCase fieldNamingCase = NamingCases.DEFAULT;
        private boolean hasHeader = true;
        private String separator = String.valueOf(',');
        private Function<String, Writer> writerFunction = fileName -> new SimpleFileWriter(false, (String)fileName);

        private Builder() {
        }

        @NotNull
        public Builder withCase(@NotNull NamingCase fieldNamingCase) {
            this.fieldNamingCase = fieldNamingCase;
            return this;
        }

        @NotNull
        public Builder withWriter(@NotNull Function<String, Writer> writerFunction) {
            this.writerFunction = writerFunction;
            return this;
        }

        @NotNull
        public Builder withHeader(boolean hasHeader) {
            this.hasHeader = hasHeader;
            return this;
        }

        @NotNull
        public Builder withSeparator(@NotNull String separator) {
            this.separator = separator;
            return this;
        }

        @NotNull
        public Builder withSeparator(@NotNull Character separator) {
            this.separator = String.valueOf(separator);
            return this;
        }

        @NotNull
        public Builder includeFields(String ... fields) {
            return this.includeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder includeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsExclude.isEmpty()) {
                throw new IllegalStateException("Can't Include Fields when Exclude Fields is present!");
            }
            this.fieldsInclude.addAll(fields);
            return this;
        }

        @NotNull
        public Builder excludeFields(String ... fields) {
            return this.excludeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder excludeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsInclude.isEmpty()) {
                throw new IllegalStateException("Can't Exclude Fields when Include Fields is present!");
            }
            this.fieldsExclude.addAll(fields);
            return this;
        }

        @NotNull
        public CsvExporter build() {
            return new CsvExporter(this.fieldsInclude, this.fieldsExclude, this.fieldNamingCase, this.writerFunction, this.hasHeader, this.separator);
        }
    }
}

