/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.annotation.parameterized.GenTime;
import io.goodforgod.dummymaker.export.ExportField;
import java.lang.reflect.Field;
import java.sql.Time;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

final class DateExportField
extends ExportField {
    private final String formatter;

    DateExportField(Field field, ExportField.Type type, String exportName) {
        super(field, type, exportName);
        this.formatter = field.getAnnotation(GenTime.class) == null ? null : field.getAnnotation(GenTime.class).formatter();
    }

    String getFormatted(Object date) {
        if (date instanceof Duration) {
            return String.valueOf(((Duration)date).toMillis());
        }
        DateTimeFormatter formatter = this.getDateFormatter(date, this.formatter);
        if (date instanceof Date) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Date)date).getTime()), TimeZone.getDefault().toZoneId()).format(formatter);
        }
        if (date instanceof LocalDate) {
            return ((LocalDate)date).format(formatter);
        }
        if (date instanceof LocalTime) {
            return ((LocalTime)date).format(formatter);
        }
        if (date instanceof LocalDateTime) {
            return ((LocalDateTime)date).format(formatter);
        }
        if (date instanceof OffsetTime) {
            return ((OffsetTime)date).format(formatter);
        }
        if (date instanceof OffsetDateTime) {
            return ((OffsetDateTime)date).format(formatter);
        }
        if (date instanceof ZonedDateTime) {
            return ((ZonedDateTime)date).format(formatter);
        }
        return String.valueOf(date);
    }

    private DateTimeFormatter getDateFormatter(Object date, String formatter) {
        if (date instanceof Time || date instanceof LocalTime) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_TIME : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof LocalDate) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_DATE : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof Date || date instanceof LocalDateTime) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof OffsetTime) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_OFFSET_TIME : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof OffsetDateTime) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof ZonedDateTime) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_ZONED_DATE_TIME : DateTimeFormatter.ofPattern(formatter);
        }
        if (date instanceof Instant) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(formatter) ? DateTimeFormatter.ISO_INSTANT : DateTimeFormatter.ofPattern(formatter);
        }
        return DateTimeFormatter.ofPattern(formatter);
    }
}

