/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.annotation.export.GenExportName;
import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.export.DateExportField;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.util.CastUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

final class ExportFieldFactory {
    private ExportFieldFactory() {
    }

    static ExportField build(Field field, Class<?> genType, NamingCase namingCase) {
        ExportField.Type type = ExportFieldFactory.getType(genType);
        String exportName = Arrays.stream(field.getDeclaredAnnotations()).filter(a -> GenExportName.class.equals(a.annotationType())).map(a -> ((GenExportName)a).value()).findFirst().orElseGet(() -> namingCase.apply(field.getName()).toString());
        return ExportFieldFactory.build(field, type, exportName);
    }

    private static ExportField build(Field field, ExportField.Type type, String fieldExportName) {
        if (type.equals((Object)ExportField.Type.DATE) && field != null) {
            return new DateExportField(field, type, fieldExportName);
        }
        return new ExportField(field, type, fieldExportName);
    }

    private static ExportField.Type getType(Class<?> type) {
        if (type == null) {
            return ExportField.Type.STRING;
        }
        if (type.equals(UUID.class)) {
            return ExportField.Type.STRING;
        }
        if (type.equals(Boolean.class)) {
            return ExportField.Type.BOOLEAN;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(BigInteger.class) || type.equals(BigDecimal.class)) {
            return ExportField.Type.NUMBER;
        }
        if (type.equals(LocalDate.class) || type.equals(LocalTime.class) || type.equals(LocalDateTime.class) || type.equals(OffsetTime.class) || type.equals(OffsetDateTime.class) || type.equals(ZonedDateTime.class) || type.equals(Instant.class) || type.equals(Year.class) || type.equals(YearMonth.class) || type.equals(MonthDay.class) || type.equals(java.util.Date.class) || type.equals(Date.class) || type.equals(Timestamp.class) || type.equals(Time.class) || type.equals(Duration.class)) {
            return ExportField.Type.DATE;
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return ExportField.Type.COLLECTION;
        }
        if (Map.class.isAssignableFrom(type)) {
            return ExportField.Type.MAP;
        }
        if (type.getSimpleName().contains("[][]")) {
            return ExportField.Type.ARRAY_2D;
        }
        if (type.getSimpleName().contains("[]")) {
            return ExportField.Type.ARRAY;
        }
        CastUtils.CastType castedType = CastUtils.CastType.of(type);
        if (CastUtils.CastType.UNKNOWN.equals((Object)castedType)) {
            return ExportField.Type.COMPLEX;
        }
        return ExportField.Type.STRING;
    }
}

