/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.annotation.export.GenExportIgnore;
import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.ExportFieldFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class ExportScanner {
    private final Predicate<Field> fieldPredicate;
    private final NamingCase namingCase;

    ExportScanner(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase namingCase) {
        Set<String> fieldsIncludes = Collections.unmodifiableSet(fieldsInclude);
        Set<String> fieldsExcludes = Collections.unmodifiableSet(fieldsExclude);
        this.namingCase = namingCase;
        this.fieldPredicate = !fieldsExcludes.isEmpty() ? field -> !fieldsExcludes.contains(field.getName()) : (!fieldsIncludes.isEmpty() ? field -> fieldsIncludes.contains(field.getName()) : field -> true);
    }

    @NotNull
    public List<ExportField> scan(Class<?> target) {
        return this.getExportFields(target).stream().map(scanField -> ExportFieldFactory.build(scanField.value(), scanField.type().raw(), this.namingCase)).collect(Collectors.toList());
    }

    @NotNull
    private List<ScanField> getExportFields(Type target) {
        if (target == null || Object.class.equals((Object)target)) {
            return Collections.emptyList();
        }
        Class targetClass = target instanceof ParameterizedType ? (Class)((ParameterizedType)target).getRawType() : (Class)target;
        List<ScanField> superFields = this.getExportFields(targetClass.getGenericSuperclass());
        List<ScanField> targetFields = Arrays.stream(targetClass.getDeclaredFields()).filter(f -> !f.isSynthetic()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isNative(f.getModifiers())).filter(f -> !Modifier.isSynchronized(f.getModifiers())).filter(this.fieldPredicate).filter(f -> Arrays.stream(f.getDeclaredAnnotations()).noneMatch(a -> GenExportIgnore.class.equals(a.annotationType()))).flatMap(f -> GenType.ofType(f.getGenericType()).map(v -> Stream.of(new ScanField((Field)f, (GenType)v))).orElse(Stream.empty())).collect(Collectors.toList());
        if (superFields.isEmpty()) {
            return targetFields;
        }
        superFields.addAll(targetFields);
        return superFields;
    }

    private static class ScanField {
        private final Field value;
        private final GenType type;

        private ScanField(Field value, GenType type) {
            this.value = value;
            this.type = type;
        }

        public Field value() {
            return this.value;
        }

        public GenType type() {
            return this.type;
        }
    }
}

