/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.export.ExportField;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

enum Format {
    CSV(".csv", ExportField.Type.STRING, ExportField.Type.BOOLEAN, ExportField.Type.NUMBER, ExportField.Type.DATE),
    JSON(".json", ExportField.Type.STRING, ExportField.Type.BOOLEAN, ExportField.Type.NUMBER, ExportField.Type.DATE, ExportField.Type.ARRAY, ExportField.Type.ARRAY_2D, ExportField.Type.COLLECTION, ExportField.Type.MAP),
    XML(".xml", ExportField.Type.STRING, ExportField.Type.BOOLEAN, ExportField.Type.NUMBER, ExportField.Type.DATE),
    SQL(".sql", ExportField.Type.STRING, ExportField.Type.BOOLEAN, ExportField.Type.NUMBER, ExportField.Type.DATE, ExportField.Type.ARRAY, ExportField.Type.ARRAY_2D, ExportField.Type.COLLECTION);

    private final Set<ExportField.Type> supported;
    private final String extension;

    private Format(String extension, ExportField.Type ... type) {
        this.extension = extension;
        this.supported = new HashSet<ExportField.Type>(Arrays.asList(type));
    }

    public boolean isTypeSupported(ExportField.Type type) {
        return this.supported.contains((Object)type);
    }

    public Set<ExportField.Type> getSupported() {
        return this.supported;
    }

    public String getExtension() {
        return this.extension;
    }
}

