/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.export.AbstractExporter;
import io.goodforgod.dummymaker.export.DateExportField;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.SimpleFileWriter;
import io.goodforgod.dummymaker.export.Writer;
import io.goodforgod.dummymaker.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class JsonExporter
extends AbstractExporter {
    private JsonExporter(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase fieldNamingCase, Function<String, Writer> writerFunction) {
        super(fieldsInclude, fieldsExclude, fieldNamingCase, writerFunction);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static JsonExporter build() {
        return new Builder().build();
    }

    @Override
    @NotNull
    protected String getExtension() {
        return "json";
    }

    private String wrap(String s) {
        return StringUtils.isEmpty(s) ? "" : "\"" + s + "\"";
    }

    @Override
    protected String convertString(String s) {
        return this.wrap(s);
    }

    @Override
    protected String convertDate(Object date, DateExportField formatterPattern) {
        return this.wrap(super.convertDate(date, formatterPattern));
    }

    @Override
    protected String convertNull() {
        return "null";
    }

    @Override
    protected Predicate<ExportField> filter() {
        return c -> c.getType() == ExportField.Type.STRING || c.getType() == ExportField.Type.BOOLEAN || c.getType() == ExportField.Type.NUMBER || c.getType() == ExportField.Type.DATE || c.getType() == ExportField.Type.ARRAY || c.getType() == ExportField.Type.ARRAY_2D || c.getType() == ExportField.Type.COLLECTION || c.getType() == ExportField.Type.MAP;
    }

    @Override
    @NotNull
    protected <T> String prefix(Class<T> type, Collection<ExportField> containers) {
        return "{";
    }

    @Override
    @NotNull
    protected <T> String suffix(Class<T> type, Collection<ExportField> containers) {
        return "}";
    }

    @Override
    @NotNull
    protected <T> String separator(Class<T> type, Collection<ExportField> containers) {
        return ",\n";
    }

    @Override
    @NotNull
    protected <T> String map(T t, Collection<ExportField> containers) {
        return containers.stream().map(c -> {
            String value = this.getValue(t, (ExportField)c);
            return StringUtils.isEmpty(value) ? "" : this.wrap(c.getName()) + ":" + value;
        }).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
    }

    @Override
    @NotNull
    protected <T> String head(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        return isCollection ? "[" : "";
    }

    @Override
    @NotNull
    protected <T> String tail(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        return isCollection ? "]" : "";
    }

    public static final class Builder {
        private final Set<String> fieldsInclude = new HashSet<String>();
        private final Set<String> fieldsExclude = new HashSet<String>();
        private NamingCase fieldNamingCase = NamingCases.DEFAULT;
        private Function<String, Writer> writerFunction = fileName -> new SimpleFileWriter(false, (String)fileName);

        private Builder() {
        }

        @NotNull
        public Builder withCase(@NotNull NamingCase fieldNamingCase) {
            this.fieldNamingCase = fieldNamingCase;
            return this;
        }

        @NotNull
        public Builder withWriter(@NotNull Function<String, Writer> writerFunction) {
            this.writerFunction = writerFunction;
            return this;
        }

        @NotNull
        public Builder includeFields(String ... fields) {
            return this.includeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder includeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsExclude.isEmpty()) {
                throw new IllegalStateException("Can't Include Fields when Exclude Fields is present!");
            }
            this.fieldsInclude.addAll(fields);
            return this;
        }

        @NotNull
        public Builder excludeFields(String ... fields) {
            return this.excludeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder excludeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsInclude.isEmpty()) {
                throw new IllegalStateException("Can't Exclude Fields when Include Fields is present!");
            }
            this.fieldsExclude.addAll(fields);
            return this;
        }

        @NotNull
        public JsonExporter build() {
            return new JsonExporter(this.fieldsInclude, this.fieldsExclude, this.fieldNamingCase, this.writerFunction);
        }
    }
}

