/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.error.GenExportException;
import io.goodforgod.dummymaker.export.Writer;
import io.goodforgod.dummymaker.util.StringUtils;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleFileWriter
implements Writer {
    private static final String DEFAULT_PATH = "";
    private final java.io.Writer writer;

    SimpleFileWriter(boolean appendFile, @NotNull String filename) {
        this(appendFile, filename, DEFAULT_PATH);
    }

    SimpleFileWriter(boolean appendFile, @NotNull String filename, @Nullable String path) {
        this(appendFile, filename, path, StandardCharsets.UTF_8);
    }

    SimpleFileWriter(boolean appendFile, @NotNull String filename, @Nullable String path, @NotNull Charset charset) {
        if (StringUtils.isBlank(filename)) {
            throw new IllegalArgumentException("File name can't be empty");
        }
        String filePath = path == null || StringUtils.isBlank(path) ? filename : (path.endsWith("/") ? path + filename : path + "/" + filename);
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, appendFile), charset));
        }
        catch (FileNotFoundException e) {
            throw new GenExportException("File not found while writing: ", e);
        }
    }

    @Override
    public void write(String value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        try {
            this.writer.append(value);
        }
        catch (IOException e) {
            throw new GenExportException("Exception occurred while writing: ", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

