/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.error.GenExportException;
import io.goodforgod.dummymaker.export.AbstractExporter;
import io.goodforgod.dummymaker.export.DateExportField;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.SimpleFileWriter;
import io.goodforgod.dummymaker.export.Writer;
import io.goodforgod.dummymaker.util.CollectionUtils;
import io.goodforgod.dummymaker.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SqlExporter
extends AbstractExporter {
    private static final Pattern ID_PATTERN = Pattern.compile("id|[gu]?uid");
    private static final Pattern ID_SUFFIX_PATTERN = Pattern.compile("(id$)|([gu]?uid$)");
    private final int batchSize;
    private final Map<Class<?>, String> dataTypes;

    private SqlExporter(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase fieldNamingCase, @NotNull Function<String, Writer> writerFunction, int batchSize, Map<Class<?>, String> dataTypes) {
        super(fieldsInclude, fieldsExclude, fieldNamingCase, writerFunction);
        this.batchSize = batchSize;
        this.dataTypes = dataTypes;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static SqlExporter build() {
        return new Builder().build();
    }

    @Override
    @NotNull
    protected String getExtension() {
        return "sql";
    }

    private String wrap(String value) {
        return "'" + value + "'";
    }

    private <T> String getCollectionName(Class<T> type) {
        return this.fieldNamingCase.apply(type.getSimpleName()).toString();
    }

    private String translateJavaTypeToSqlType(Class<?> exportFieldType) {
        return this.dataTypes.getOrDefault(exportFieldType, "VARCHAR");
    }

    private String translateContainerToSqlType(ExportField container) {
        String field = container.getName();
        Class<?> fieldType = this.extractType(container.getType(), container.getField());
        switch (container.getType()) {
            case DATE: {
                String dateType = this.translateJavaTypeToSqlType(fieldType);
                return field + "\t" + dateType;
            }
            case ARRAY: 
            case COLLECTION: {
                return field + "\t" + this.translateJavaTypeToSqlType(fieldType) + "[]";
            }
            case ARRAY_2D: {
                return field + "\t" + this.translateJavaTypeToSqlType(fieldType) + "[][]";
            }
        }
        return field + "\t" + this.translateJavaTypeToSqlType(fieldType);
    }

    private <T> String buildInsertQuery(Class<T> type, Collection<ExportField> containers) {
        String collectionName = this.getCollectionName(type);
        StringBuilder builder = new StringBuilder("INSERT INTO ").append(collectionName).append("(");
        String names = containers.stream().map(ExportField::getName).collect(Collectors.joining(", "));
        return builder.append(names).append(") ").append("VALUES\n").toString();
    }

    private String getPrimaryField(Collection<ExportField> containers) {
        return containers.stream().map(ExportField::getName).filter(name -> ID_PATTERN.matcher((CharSequence)name).matches()).findFirst().orElseGet(() -> containers.stream().map(ExportField::getName).filter(name -> ID_SUFFIX_PATTERN.matcher((CharSequence)name).matches()).findFirst().orElseGet(() -> containers.stream().filter(e -> e.getType().equals((Object)ExportField.Type.NUMBER)).map(ExportField::getName).findFirst().orElseGet(() -> ((ExportField)containers.iterator().next()).getName())));
    }

    @Override
    protected String convertArray(Object array) {
        Class<?> type = array.getClass().getComponentType();
        String sqlType = this.translateJavaTypeToSqlType(type);
        String value = super.convertArray(array);
        String result = sqlType.equals("VARCHAR") || sqlType.equals("CHAR") ? value.replace("[", "{\"").replace("]", "\"}").replace(",", "\",\"").replace(" ", "") : value.replace("[", "{").replace("]", "}");
        return this.wrap(result);
    }

    @Override
    protected String convertCollection(Collection<?> collection) {
        return this.convertArray(collection.toArray());
    }

    @Override
    protected String convertDate(Object date, DateExportField formatterPattern) {
        return this.wrap(super.convertDate(date, formatterPattern));
    }

    @Override
    protected String convertString(String s) {
        return this.wrap(super.convertString(s));
    }

    private Class<?> extractType(ExportField.Type type, Field field) {
        switch (type) {
            case ARRAY: {
                return field.getType().getComponentType();
            }
            case ARRAY_2D: {
                return field.getType().getComponentType().getComponentType();
            }
            case COLLECTION: {
                return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            }
        }
        return field.getType();
    }

    @Override
    protected Predicate<ExportField> filter() {
        return c -> c.getType() == ExportField.Type.STRING || c.getType() == ExportField.Type.BOOLEAN || c.getType() == ExportField.Type.NUMBER || c.getType() == ExportField.Type.DATE || c.getType() == ExportField.Type.ARRAY || c.getType() == ExportField.Type.ARRAY_2D || c.getType() == ExportField.Type.COLLECTION;
    }

    @Override
    protected String convertNull() {
        return "NULL";
    }

    @Override
    @NotNull
    protected <T> String head(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        String collectionName = this.getCollectionName(type);
        StringBuilder builder = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(collectionName).append("(\n");
        String resultValues = containers.stream().map(c -> "\t" + this.translateContainerToSqlType((ExportField)c)).collect(Collectors.joining(",\n"));
        builder.append(resultValues);
        String primaryKeyField = this.getPrimaryField(containers);
        return builder.append(",\n").append("\tPRIMARY KEY (").append(primaryKeyField).append(")\n);\n\n").toString();
    }

    @Override
    @NotNull
    protected <T> String prefix(Class<T> type, Collection<ExportField> containers) {
        return this.buildInsertQuery(type, containers);
    }

    @Override
    @NotNull
    protected <T> String suffix(Class<T> type, Collection<ExportField> containers) {
        return ";";
    }

    @Override
    @NotNull
    protected <T> String map(T value, Collection<ExportField> containers) {
        String resultValues = containers.stream().map(c -> this.getValue(value, (ExportField)c)).collect(Collectors.joining(", "));
        return "(" + resultValues + ")";
    }

    @Override
    public void exportAsFile(@NotNull Collection<?> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Object firstValue = collection.iterator().next();
        try (Writer writer = this.getWriter(firstValue.getClass().getSimpleName());){
            this.exportAsStringInternal(collection, writer::write);
        }
        catch (Exception e) {
            throw new GenExportException("Error occurred while exporting due to: ", e);
        }
    }

    @Override
    public <T> void streamToFile(@NotNull Stream<T> stream, Class<T> type) {
        try (Writer writer = this.getWriter(type.getSimpleName());){
            this.streamToStringInternal(stream, type, writer::write);
        }
        catch (Exception e) {
            throw new GenExportException("Error occurred while exporting due to: ", e);
        }
    }

    @Override
    @NotNull
    public String exportAsString(@NotNull Collection<?> collection) {
        StringBuilder builder = new StringBuilder();
        this.exportAsStringInternal(collection, builder::append);
        return builder.toString();
    }

    @Override
    @NotNull
    public <T> String streamToString(@NotNull Stream<T> stream, Class<T> type) {
        StringBuilder builder = new StringBuilder();
        this.streamToStringInternal(stream, type, builder::append);
        return builder.toString();
    }

    private void exportAsStringInternal(@NotNull Collection<?> collection, Consumer<String> stringConsumer) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        Object firstValue = collection.iterator().next();
        Class<?> type = firstValue.getClass();
        List<ExportField> containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return;
        }
        stringConsumer.accept(this.head(type, containers, true));
        Iterator<?> iterator = collection.iterator();
        int i = this.batchSize;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (i == this.batchSize) {
                stringConsumer.accept(this.buildInsertQuery(type, containers));
            }
            stringConsumer.accept(this.map(next, containers));
            String suffix = --i <= 0 || !iterator.hasNext() ? ";\n\n" : ",\n";
            stringConsumer.accept(suffix);
            if (i > 0) continue;
            i = this.batchSize;
        }
    }

    private <T> void streamToStringInternal(@NotNull Stream<T> stream, Class<T> type, Consumer<String> stringConsumer) {
        Collection containers = this.scan(type).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return;
        }
        AtomicInteger counter = new AtomicInteger(this.batchSize);
        AtomicReference firstValueRef = new AtomicReference();
        stream.filter(Objects::nonNull).forEach(value -> {
            AtomicReference atomicReference = firstValueRef;
            synchronized (atomicReference) {
                String valueAsString = this.map(value, containers);
                if (StringUtils.isNotBlank(valueAsString)) {
                    boolean isFirst;
                    int currentCounter = counter.getAndDecrement();
                    if (currentCounter <= 0) {
                        counter.set(this.batchSize - 1);
                        currentCounter = this.batchSize;
                    }
                    boolean bl = isFirst = firstValueRef.get() == null;
                    if (isFirst) {
                        String head = this.head(type, containers, true);
                        stringConsumer.accept(head);
                        firstValueRef.set(value);
                    } else if (currentCounter == this.batchSize) {
                        stringConsumer.accept(";\n\n");
                    } else {
                        stringConsumer.accept(",\n");
                    }
                    if (currentCounter == this.batchSize) {
                        stringConsumer.accept(this.buildInsertQuery(type, containers));
                    }
                    stringConsumer.accept(valueAsString);
                }
            }
        });
        if (firstValueRef.get() != null) {
            stringConsumer.accept(";");
        }
    }

    public static final class Builder {
        private final Set<String> fieldsInclude = new HashSet<String>();
        private final Set<String> fieldsExclude = new HashSet<String>();
        private NamingCase fieldNamingCase = NamingCases.SNAKE_LOWER_CASE;
        private Function<String, Writer> writerFunction = fileName -> new SimpleFileWriter(false, (String)fileName);
        private int batchSize = 999;
        private final Map<Class<?>, String> dataTypes = Builder.buildDefaultDataTypeMap();

        private Builder() {
        }

        @NotNull
        public Builder withCase(@NotNull NamingCase fieldNamingCase) {
            this.fieldNamingCase = fieldNamingCase;
            return this;
        }

        @NotNull
        public Builder withWriter(@NotNull Function<String, Writer> writerFunction) {
            this.writerFunction = writerFunction;
            return this;
        }

        @NotNull
        public Builder withBatchSize(int batchSize) {
            if (batchSize > 999 || batchSize < 1) {
                throw new IllegalArgumentException("Batch Size can be from 1 to 999");
            }
            this.batchSize = batchSize;
            return this;
        }

        @NotNull
        public Builder withDataType(@NotNull Class<?> fieldDateType, @NotNull String sqlDataType) {
            this.dataTypes.put(fieldDateType, sqlDataType);
            return this;
        }

        @NotNull
        public Builder withDataTypes(@NotNull Map<Class<?>, String> dataTypes) {
            this.dataTypes.putAll(dataTypes);
            return this;
        }

        @NotNull
        public Builder includeFields(String ... fields) {
            return this.includeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder includeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsExclude.isEmpty()) {
                throw new IllegalStateException("Can't Include Fields when Exclude Fields is present!");
            }
            this.fieldsInclude.addAll(fields);
            return this;
        }

        @NotNull
        public Builder excludeFields(String ... fields) {
            return this.excludeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder excludeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsInclude.isEmpty()) {
                throw new IllegalStateException("Can't Exclude Fields when Include Fields is present!");
            }
            this.fieldsExclude.addAll(fields);
            return this;
        }

        @NotNull
        public SqlExporter build() {
            return new SqlExporter(this.fieldsInclude, this.fieldsExclude, this.fieldNamingCase, this.writerFunction, this.batchSize, this.dataTypes);
        }

        private static Map<Class<?>, String> buildDefaultDataTypeMap() {
            HashMap typeMap = new HashMap(35);
            typeMap.put(Boolean.TYPE, "BOOLEAN");
            typeMap.put(Boolean.class, "BOOLEAN");
            typeMap.put(Byte.TYPE, "BYTE");
            typeMap.put(Byte.class, "BYTE");
            typeMap.put(Short.TYPE, "SMALLINT");
            typeMap.put(Short.class, "SMALLINT");
            typeMap.put(Integer.TYPE, "INT");
            typeMap.put(Integer.class, "INT");
            typeMap.put(Long.TYPE, "BIGINT");
            typeMap.put(Long.class, "BIGINT");
            typeMap.put(Float.TYPE, "DOUBLE PRECISION");
            typeMap.put(Float.class, "DOUBLE PRECISION");
            typeMap.put(Double.TYPE, "DOUBLE PRECISION");
            typeMap.put(Double.class, "DOUBLE PRECISION");
            typeMap.put(BigInteger.class, "BIGINT");
            typeMap.put(BigDecimal.class, "NUMERIC");
            typeMap.put(Character.TYPE, "CHAR");
            typeMap.put(Character.class, "CHAR");
            typeMap.put(String.class, "VARCHAR");
            typeMap.put(CharSequence.class, "VARCHAR");
            typeMap.put(UUID.class, "UUID");
            typeMap.put(Object.class, "VARCHAR");
            typeMap.put(Duration.class, "BIGINT");
            typeMap.put(Time.class, "TIME");
            typeMap.put(LocalTime.class, "TIME");
            typeMap.put(LocalDate.class, "DATE");
            typeMap.put(Date.class, "TIMESTAMP");
            typeMap.put(java.util.Date.class, "TIMESTAMP");
            typeMap.put(Timestamp.class, "TIMESTAMP");
            typeMap.put(LocalDateTime.class, "TIMESTAMP");
            typeMap.put(OffsetTime.class, "TIME WITH TIME ZONE");
            typeMap.put(OffsetDateTime.class, "TIMESTAMP WITH TIME ZONE");
            typeMap.put(ZonedDateTime.class, "TIMESTAMP WITH TIME ZONE");
            return typeMap;
        }
    }
}

