/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.export;

import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.export.AbstractExporter;
import io.goodforgod.dummymaker.export.ExportField;
import io.goodforgod.dummymaker.export.SimpleFileWriter;
import io.goodforgod.dummymaker.export.Writer;
import io.goodforgod.dummymaker.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class XmlExporter
extends AbstractExporter {
    private static final String DEFAULT_TAG_LIST_SUFFIX = "List";
    private final Function<String, String> listTagSuffix;

    private XmlExporter(Set<String> fieldsInclude, Set<String> fieldsExclude, NamingCase fieldNamingCase, Function<String, Writer> writerFunction, Function<String, String> listTagSuffix) {
        super(fieldsInclude, fieldsExclude, fieldNamingCase, writerFunction);
        this.listTagSuffix = listTagSuffix;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static XmlExporter build() {
        return new Builder().build();
    }

    @Override
    @NotNull
    protected String getExtension() {
        return "xml";
    }

    private String openXmlTag(String value) {
        return "<" + value + ">";
    }

    private String closeXmlTag(String value) {
        return "</" + value + ">";
    }

    @Override
    protected Predicate<ExportField> filter() {
        return c -> c.getType() == ExportField.Type.STRING || c.getType() == ExportField.Type.BOOLEAN || c.getType() == ExportField.Type.NUMBER || c.getType() == ExportField.Type.DATE;
    }

    @Override
    @NotNull
    protected <T> String prefix(Class<T> type, Collection<ExportField> containers) {
        return this.openXmlTag(this.fieldNamingCase.apply(type.getSimpleName()).toString()) + "\n";
    }

    @Override
    @NotNull
    protected <T> String suffix(Class<T> type, Collection<ExportField> containers) {
        return "\n" + this.closeXmlTag(this.fieldNamingCase.apply(type.getSimpleName()).toString());
    }

    @Override
    @NotNull
    protected <T> String separator(Class<T> type, Collection<ExportField> containers) {
        return "\n";
    }

    @Override
    @NotNull
    protected <T> String map(T t, Collection<ExportField> containers) {
        return containers.stream().map(c -> {
            String value = this.getValue(t, (ExportField)c);
            if (StringUtils.isEmpty(value)) {
                return "";
            }
            String tag = c.getName();
            return "\t" + this.openXmlTag(tag) + value + this.closeXmlTag(tag);
        }).collect(Collectors.joining("\n"));
    }

    @Override
    @NotNull
    protected <T> String head(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        String typeAsString = type.getSimpleName();
        return isCollection ? this.openXmlTag(this.fieldNamingCase.apply(this.listTagSuffix.apply(typeAsString)).toString()) + "\n" : "";
    }

    @Override
    @NotNull
    protected <T> String tail(Class<T> type, Collection<ExportField> containers, boolean isCollection) {
        String typeAsString = type.getSimpleName();
        return isCollection ? "\n" + this.closeXmlTag(this.fieldNamingCase.apply(this.listTagSuffix.apply(typeAsString)).toString()) : "";
    }

    public static final class Builder {
        private final Set<String> fieldsInclude = new HashSet<String>();
        private final Set<String> fieldsExclude = new HashSet<String>();
        private NamingCase fieldNamingCase = NamingCases.DEFAULT;
        private Function<String, Writer> writerFunction = fileName -> new SimpleFileWriter(false, (String)fileName);
        private Function<String, String> listTagSuffix = name -> name + XmlExporter.DEFAULT_TAG_LIST_SUFFIX;

        private Builder() {
        }

        @NotNull
        public Builder withCase(@NotNull NamingCase fieldNamingCase) {
            this.fieldNamingCase = fieldNamingCase;
            return this;
        }

        @NotNull
        public Builder withWriter(@NotNull Function<String, Writer> writerFunction) {
            this.writerFunction = writerFunction;
            return this;
        }

        @NotNull
        public Builder withListSuffix(@NotNull Function<String, String> listTagSuffix) {
            this.listTagSuffix = listTagSuffix;
            return this;
        }

        @NotNull
        public Builder includeFields(String ... fields) {
            return this.includeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder includeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsExclude.isEmpty()) {
                throw new IllegalStateException("Can't Include Fields when Exclude Fields is present!");
            }
            this.fieldsInclude.addAll(fields);
            return this;
        }

        @NotNull
        public Builder excludeFields(String ... fields) {
            return this.excludeFields(Arrays.asList(fields));
        }

        @NotNull
        public Builder excludeFields(@NotNull Collection<String> fields) {
            if (!this.fieldsInclude.isEmpty()) {
                throw new IllegalStateException("Can't Exclude Fields when Include Fields is present!");
            }
            this.fieldsExclude.addAll(fields);
            return this;
        }

        @NotNull
        public XmlExporter build() {
            return new XmlExporter(this.fieldsInclude, this.fieldsExclude, this.fieldNamingCase, this.writerFunction, this.listTagSuffix);
        }
    }
}

