/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.parameterized;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.ObjectGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.lang.reflect.Array;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Array2DParameterizedGenerator
implements ParameterizedGenerator<Object> {
    private static final ObjectGenerator DEFAULT_GENERATOR = new ObjectGenerator();
    private final int minFirst;
    private final int maxFirst;
    private final int fixedFirst;
    private final int minSecond;
    private final int maxSecond;
    private final int fixedSecond;
    @Nullable
    private final Generator<?> generator;

    public Array2DParameterizedGenerator(int minFirst, int maxFirst, int minSecond, int maxSecond) {
        this(minFirst, maxFirst, -1, minSecond, maxSecond, -1, null);
    }

    public Array2DParameterizedGenerator(int minFirst, int maxFirst, int fixedFirst, int minSecond, int maxSecond, int fixedSecond, @Nullable Generator<?> generator) {
        if (minFirst < 1) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + minFirst);
        }
        if (maxFirst < minFirst) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + maxFirst + " when Min was " + minFirst);
        }
        if (minSecond < 1) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + minSecond);
        }
        if (maxSecond < minSecond) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + maxSecond + " when Min was " + minSecond);
        }
        this.minFirst = minFirst;
        this.maxFirst = maxFirst;
        this.fixedFirst = fixedFirst;
        this.minSecond = minSecond;
        this.maxSecond = maxSecond;
        this.fixedSecond = fixedSecond;
        this.generator = generator;
    }

    @Override
    public Object get(@NotNull GenParameters parameters) {
        if (!parameters.parameterType().raw().getTypeName().endsWith("[][]")) {
            return null;
        }
        Class<?> componentType = parameters.parameterType().raw().getComponentType().getComponentType();
        return this.getCollector(componentType, () -> this.generator != null ? this.generator.get() : parameters.genericBuilder().build(componentType));
    }

    @Override
    public Object get() {
        return this.getCollector(Object.class, DEFAULT_GENERATOR);
    }

    private Object getCollector(Class<?> arrayType, Supplier<Object> supplier) {
        int sizeFirst = this.fixedFirst < 1 ? RandomUtils.random(this.minFirst, this.maxFirst) : this.fixedFirst;
        int sizeSecond = this.fixedSecond < 1 ? RandomUtils.random(this.minSecond, this.maxSecond) : this.fixedSecond;
        Object elementFirst = supplier.get();
        if (elementFirst == null) {
            return Array.newInstance(arrayType, 0, 0);
        }
        Object collectorFirst = Array.newInstance(arrayType, sizeFirst, sizeSecond);
        for (int i = 0; i < sizeFirst; ++i) {
            Object collectorSecond = Array.get(collectorFirst, i);
            for (int j = 0; j < sizeSecond; ++j) {
                Object element = supplier.get();
                Array.set(collectorSecond, j, element);
            }
        }
        return collectorFirst;
    }
}

