/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.parameterized;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.ObjectGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.lang.reflect.Array;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayParameterizedGenerator
implements ParameterizedGenerator<Object> {
    private static final ObjectGenerator DEFAULT_GENERATOR = new ObjectGenerator();
    private final int min;
    private final int max;
    private final int fixed;
    @Nullable
    private final Generator<?> generator;

    public ArrayParameterizedGenerator(int min, int max) {
        this(min, max, -1, null);
    }

    public ArrayParameterizedGenerator(int min, int max, @Nullable Generator<?> generator) {
        this(min, max, -1, generator);
    }

    public ArrayParameterizedGenerator(int fixed, @Nullable Generator<?> generator) {
        this(1, 3, fixed, generator);
    }

    public ArrayParameterizedGenerator(int min, int max, int fixed, @Nullable Generator<?> generator) {
        if (min < 1) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + max + " when Min was " + min);
        }
        this.min = min;
        this.max = max;
        this.fixed = fixed;
        this.generator = generator;
    }

    @Override
    public Object get(@NotNull GenParameters parameters) {
        if (!parameters.parameterType().raw().getTypeName().endsWith("[]")) {
            return null;
        }
        Class<?> componentType = parameters.parameterType().raw().getComponentType();
        return this.getCollector(componentType, () -> this.generator != null ? this.generator.get() : parameters.genericBuilder().build(componentType));
    }

    @Override
    public Object get() {
        return this.getCollector(Object.class, DEFAULT_GENERATOR);
    }

    private Object getCollector(Class<?> arrayType, Supplier<Object> supplier) {
        int size = this.fixed < 1 ? RandomUtils.random(this.min, this.max) : this.fixed;
        Object firstElement = supplier.get();
        if (firstElement == null) {
            return Array.newInstance(arrayType, 0);
        }
        Object collector = Array.newInstance(arrayType, size);
        Array.set(collector, 0, firstElement);
        for (int i = 1; i < size; ++i) {
            Object element = supplier.get();
            Array.set(collector, i, element);
        }
        return collector;
    }
}

