/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.parameterized;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class EnumParameterizedGenerator
implements ParameterizedGenerator<Object> {
    private final Set<String> only;
    private final Set<String> exclude;

    public EnumParameterizedGenerator(String[] only, String[] exclude) {
        this.only = new HashSet<String>(Arrays.asList(only));
        this.exclude = new HashSet<String>(Arrays.asList(exclude));
    }

    @Override
    public Object get(@NotNull GenParameters parameters) {
        Predicate<String> predicate = !this.only.isEmpty() ? this.only::contains : (!this.exclude.isEmpty() ? s -> !this.exclude.contains(s) : s -> true);
        Field[] fields = parameters.parameterType().raw().getFields();
        List candidates = Arrays.stream(fields).filter(f -> predicate.test(f.getName())).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return null;
        }
        int index = RandomUtils.random(candidates.size() - 1);
        Object e = Enum.valueOf(parameters.parameterType().raw(), ((Field)candidates.get(index)).getName());
        if (CharSequence.class.isAssignableFrom(parameters.parameterType().raw())) {
            return parameters.namingCase().apply(((Enum)e).toString()).toString();
        }
        return e;
    }

    @Override
    public Object get() {
        return null;
    }
}

