/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.parameterized;

import io.goodforgod.dummymaker.GenType;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.ObjectGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapParameterizedGenerator
implements ParameterizedGenerator<Object> {
    private static final ObjectGenerator DEFAULT_GENERATOR = new ObjectGenerator();
    private final int min;
    private final int max;
    private final int fixed;
    @Nullable
    private final Generator<?> keyGenerator;
    @Nullable
    private final Generator<?> valueGenerator;

    public MapParameterizedGenerator(int min, int max) {
        this(min, max, -1, null, null);
    }

    public MapParameterizedGenerator(int min, int max, @Nullable Generator<?> keyGenerator, @Nullable Generator<?> valueGenerator) {
        this(min, max, -1, keyGenerator, valueGenerator);
    }

    public MapParameterizedGenerator(int fixed, @Nullable Generator<?> keyGenerator, @Nullable Generator<?> valueGenerator) {
        this(1, 3, fixed, keyGenerator, valueGenerator);
    }

    public MapParameterizedGenerator(int min, int max, int fixed, @Nullable Generator<?> keyGenerator, @Nullable Generator<?> valueGenerator) {
        if (min < 1) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + max + " when Min was " + min);
        }
        this.min = min;
        this.max = max;
        this.fixed = fixed;
        this.keyGenerator = keyGenerator;
        this.valueGenerator = valueGenerator;
    }

    @Override
    public Object get(@NotNull GenParameters parameters) {
        if (parameters.parameterType().generics().size() != 2) {
            return this.get();
        }
        int size = this.fixed < 1 ? RandomUtils.random(this.min, this.max) : this.fixed;
        GenType keyType = parameters.parameterType().generics().get(0);
        GenType valueType = parameters.parameterType().generics().get(1);
        Map collector = Collections.emptyMap();
        for (int i = 0; i < size; ++i) {
            Object value;
            Object key = this.keyGenerator != null ? this.keyGenerator.get() : parameters.genericBuilder().build(keyType.raw());
            Object object = value = this.valueGenerator != null ? this.valueGenerator.get() : parameters.genericBuilder().build(valueType.raw());
            if (key == null) continue;
            if (collector.isEmpty()) {
                collector = this.buildCollector(parameters.parameterType(), size);
            }
            collector.put(key, value);
        }
        return collector;
    }

    @Override
    public Object get() {
        int size = this.fixed < 1 ? RandomUtils.random(this.min, this.max) : this.fixed;
        HashMap<Object, Object> collector = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.keyGenerator != null ? this.keyGenerator.get() : DEFAULT_GENERATOR.get();
            Object value = this.valueGenerator != null ? this.valueGenerator.get() : DEFAULT_GENERATOR.get();
            collector.put(key, value);
        }
        return collector;
    }

    private <K, V> Map<K, V> buildCollector(@NotNull GenType fieldType, int size) {
        if (IdentityHashMap.class.equals(fieldType.raw())) {
            return new IdentityHashMap(size);
        }
        if (LinkedHashMap.class.equals(fieldType.raw())) {
            return new LinkedHashMap(size);
        }
        if (WeakHashMap.class.equals(fieldType.raw())) {
            return new WeakHashMap(size);
        }
        if (ConcurrentHashMap.class.equals(fieldType.raw())) {
            return new ConcurrentHashMap(size);
        }
        if (TreeMap.class.equals(fieldType.raw())) {
            return new TreeMap();
        }
        if (ConcurrentSkipListMap.class.equals(fieldType.raw())) {
            return new ConcurrentSkipListMap();
        }
        return new HashMap(size);
    }
}

