/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.parameterized;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DateGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DateSqlGenerator;
import io.goodforgod.dummymaker.generator.simple.time.DayOfWeekGenerator;
import io.goodforgod.dummymaker.generator.simple.time.InstantGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalDateGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.LocalTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.MonthDayGenerator;
import io.goodforgod.dummymaker.generator.simple.time.MonthGenerator;
import io.goodforgod.dummymaker.generator.simple.time.OffsetDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.OffsetTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.TimeSqlGenerator;
import io.goodforgod.dummymaker.generator.simple.time.TimestampGenerator;
import io.goodforgod.dummymaker.generator.simple.time.YearGenerator;
import io.goodforgod.dummymaker.generator.simple.time.YearMonthGenerator;
import io.goodforgod.dummymaker.generator.simple.time.ZonedDateTimeGenerator;
import io.goodforgod.dummymaker.generator.simple.time.ZonedOffsetGenerator;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;

public final class TimeParameterizedGenerator
implements ParameterizedGenerator<Object> {
    private final InstantGenerator instantGenerator;
    private final LocalDateGenerator localDateGenerator;
    private final LocalDateTimeGenerator localDateTimeGenerator;
    private final LocalTimeGenerator localTimeGenerator;
    private final OffsetDateTimeGenerator offsetDateTimeGenerator;
    private final OffsetTimeGenerator offsetTimeGenerator;
    private final ZonedDateTimeGenerator zonedDateTimeGenerator;
    private final ZonedOffsetGenerator zonedOffsetGenerator;
    private final DayOfWeekGenerator dayOfWeekGenerator;
    private final MonthGenerator monthGenerator;
    private final MonthDayGenerator monthDayGenerator;
    private final YearGenerator yearGenerator;
    private final YearMonthGenerator yearMonthGenerator;
    private final DateGenerator dateGenerator;
    private final DateSqlGenerator dateSqlGenerator;
    private final TimeSqlGenerator timeSqlGenerator;
    private final TimestampGenerator timestampGenerator;
    private final DateTimeFormatter formatter;

    public TimeParameterizedGenerator(long fromUnixTime, long toUnixTime, String formatter) {
        this.instantGenerator = new InstantGenerator(fromUnixTime, toUnixTime);
        this.localDateGenerator = new LocalDateGenerator(fromUnixTime, toUnixTime);
        this.localDateTimeGenerator = new LocalDateTimeGenerator(fromUnixTime, toUnixTime);
        this.localTimeGenerator = new LocalTimeGenerator(fromUnixTime, toUnixTime);
        this.offsetDateTimeGenerator = new OffsetDateTimeGenerator(fromUnixTime, toUnixTime);
        this.offsetTimeGenerator = new OffsetTimeGenerator(fromUnixTime, toUnixTime);
        this.zonedDateTimeGenerator = new ZonedDateTimeGenerator(fromUnixTime, toUnixTime);
        this.zonedOffsetGenerator = new ZonedOffsetGenerator();
        this.dayOfWeekGenerator = new DayOfWeekGenerator();
        this.monthGenerator = new MonthGenerator(fromUnixTime, toUnixTime);
        this.monthDayGenerator = new MonthDayGenerator(fromUnixTime, toUnixTime);
        this.yearGenerator = new YearGenerator(fromUnixTime, toUnixTime);
        this.yearMonthGenerator = new YearMonthGenerator(fromUnixTime, toUnixTime);
        this.dateGenerator = new DateGenerator(fromUnixTime, toUnixTime);
        this.dateSqlGenerator = new DateSqlGenerator(fromUnixTime, toUnixTime);
        this.timeSqlGenerator = new TimeSqlGenerator(fromUnixTime, toUnixTime);
        this.timestampGenerator = new TimestampGenerator(fromUnixTime, toUnixTime);
        this.formatter = DateTimeFormatter.ofPattern(formatter);
    }

    @Override
    public Object get(@NotNull GenParameters parameters) {
        Class<?> fieldClass = parameters.parameterType().raw();
        if (ZoneOffset.class.isAssignableFrom(fieldClass)) {
            return this.zonedOffsetGenerator.get();
        }
        if (DayOfWeek.class.isAssignableFrom(fieldClass)) {
            return this.dayOfWeekGenerator.get();
        }
        if (Month.class.isAssignableFrom(fieldClass)) {
            return this.monthGenerator.get();
        }
        if (MonthDay.class.isAssignableFrom(fieldClass)) {
            return this.monthDayGenerator.get();
        }
        if (Year.class.isAssignableFrom(fieldClass)) {
            return this.yearGenerator.get();
        }
        if (YearMonth.class.isAssignableFrom(fieldClass)) {
            return this.yearMonthGenerator.get();
        }
        if (Instant.class.isAssignableFrom(fieldClass)) {
            return this.instantGenerator.get();
        }
        if (ZonedDateTime.class.isAssignableFrom(fieldClass)) {
            return this.zonedDateTimeGenerator.get();
        }
        if (OffsetDateTime.class.isAssignableFrom(fieldClass)) {
            return this.offsetDateTimeGenerator.get();
        }
        if (OffsetTime.class.isAssignableFrom(fieldClass)) {
            return this.offsetTimeGenerator.get();
        }
        if (LocalDateTime.class.isAssignableFrom(fieldClass)) {
            return this.localDateTimeGenerator.get();
        }
        if (LocalDate.class.isAssignableFrom(fieldClass)) {
            return this.localDateGenerator.get();
        }
        if (LocalTime.class.isAssignableFrom(fieldClass)) {
            return this.localTimeGenerator.get();
        }
        if (Timestamp.class.isAssignableFrom(fieldClass)) {
            return this.timestampGenerator.get();
        }
        if (java.util.Date.class.isAssignableFrom(fieldClass)) {
            return this.dateGenerator.get();
        }
        if (Time.class.isAssignableFrom(fieldClass)) {
            return this.timeSqlGenerator.get();
        }
        if (Date.class.isAssignableFrom(fieldClass)) {
            return this.dateSqlGenerator.get();
        }
        OffsetDateTime dateTime = this.offsetDateTimeGenerator.get();
        return dateTime.format(this.formatter);
    }

    @Override
    public Object get() {
        OffsetDateTime dateTime = this.offsetDateTimeGenerator.get();
        return dateTime.format(this.formatter);
    }
}

