/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.string.NounGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.net.URI;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class UriGenerator
implements ParameterizedGenerator<URI> {
    private static final Pattern PATTERN = Pattern.compile("uri|resource|path", 2);
    private static final NounGenerator NOUN_GENERATOR = new NounGenerator();

    @Override
    public URI get(@NotNull GenParameters parameters) {
        return UriGenerator.get(() -> NOUN_GENERATOR.get(parameters));
    }

    @Override
    public URI get() {
        return UriGenerator.get(NOUN_GENERATOR::get);
    }

    private static URI get(Supplier<String> pathSupplier) {
        int total = RandomUtils.random(1, 5);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < total; ++i) {
            builder.append("/").append(pathSupplier.get());
        }
        return URI.create(builder.toString());
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

