/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.DomainBundle;
import io.goodforgod.dummymaker.bundle.LoginBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.generator.simple.UriGenerator;
import java.net.URI;
import java.net.URL;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class UrlGenerator
implements ParameterizedGenerator<URL> {
    private static final Pattern PATTERN = Pattern.compile("site|website|url|server|link", 2);
    private static final UriGenerator URI_GENERATOR = new UriGenerator();
    private static final Bundle LOGIN_BUNDLE = new LoginBundle();
    private static final Bundle DOMAIN_BUNDLE = new DomainBundle();

    @Override
    public URL get(@NotNull GenParameters parameters) {
        return UrlGenerator.get(() -> URI_GENERATOR.get(parameters), parameters.localisation());
    }

    @Override
    public URL get() {
        return UrlGenerator.get(URI_GENERATOR::get, Localisation.ENGLISH);
    }

    private static URL get(@NotNull Supplier<URI> uriSupplier, @NotNull Localisation localisation) {
        try {
            String urlAsString = "https://" + LOGIN_BUNDLE.random(localisation).replace(".", "") + DOMAIN_BUNDLE.random(localisation) + uriSupplier.get();
            return URI.create(urlAsString).toURL();
        }
        catch (Exception e) {
            try {
                return URI.create("https://example.com").toURL();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

