/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.number;

import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CharacterGenerator
implements ParameterizedGenerator<Character> {
    private static final Pattern PATTERN = Pattern.compile("letter|character", 2);
    private static final List<Character> LETTERS_RU = Arrays.asList(Character.valueOf('\u0430'), Character.valueOf('\u0431'), Character.valueOf('\u0432'), Character.valueOf('\u0433'), Character.valueOf('\u0434'), Character.valueOf('\u0435'), Character.valueOf('\u0451'), Character.valueOf('\u0436'), Character.valueOf('\u0437'), Character.valueOf('\u0438'), Character.valueOf('\u043a'), Character.valueOf('\u043b'), Character.valueOf('\u043c'), Character.valueOf('\u043d'), Character.valueOf('\u043e'), Character.valueOf('\u043f'), Character.valueOf('\u0440'), Character.valueOf('\u0441'), Character.valueOf('\u0442'), Character.valueOf('\u0443'), Character.valueOf('\u0444'), Character.valueOf('\u0445'), Character.valueOf('\u0447'), Character.valueOf('\u0448'), Character.valueOf('\u0449'), Character.valueOf('\u044a'), Character.valueOf('\u044b'), Character.valueOf('\u044c'), Character.valueOf('\u044d'), Character.valueOf('\u044e'), Character.valueOf('\u044f'));

    @Override
    public Character get(@NotNull GenParameters parameters) {
        if (parameters.localisation() == Localisation.RUSSIAN) {
            Character ruLetter = CollectionUtils.random(LETTERS_RU);
            if (parameters.namingCase() == NamingCases.DEFAULT) {
                return Character.valueOf(ThreadLocalRandom.current().nextBoolean() ? Character.toUpperCase(ruLetter.charValue()) : ruLetter.charValue());
            }
            return Character.valueOf(parameters.namingCase().apply(ruLetter.toString()).charAt(0));
        }
        Character character = this.get();
        if (parameters.namingCase() == NamingCases.DEFAULT) {
            return character;
        }
        return Character.valueOf(parameters.namingCase().apply(character.toString()).toString().charAt(0));
    }

    @Override
    @NotNull
    public Character get() {
        char character = (char)ThreadLocalRandom.current().nextInt(97, 122);
        boolean isUpper = ThreadLocalRandom.current().nextBoolean();
        return Character.valueOf(isUpper ? Character.toUpperCase(character) : character);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

