/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.number;

import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class IntegerGenerator
implements Generator<Integer> {
    private static final Pattern PATTERN = Pattern.compile("num(ber)?|counter|series", 2);
    private final int from;
    private final int to;

    public IntegerGenerator() {
        this(0, Integer.MAX_VALUE);
    }

    public IntegerGenerator(int from, int to) {
        this.from = from;
        this.to = to;
    }

    @Override
    @NotNull
    public Integer get() {
        return RandomUtils.random(this.from, this.to);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(60).build();
    }
}

