/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.CityBundle;
import io.goodforgod.dummymaker.bundle.DistrictBundle;
import io.goodforgod.dummymaker.bundle.StreetBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class AddressGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("addr(ess)?", 2);
    private static final Bundle STREET_BUNDLE = new StreetBundle();
    private static final Bundle DISTRICT_BUNDLE = new DistrictBundle();
    private static final Bundle CITY_BUNDLE = new CityBundle();

    @Override
    @NotNull
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(AddressGenerator.getValue(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return AddressGenerator.getValue(Localisation.ENGLISH);
    }

    private static String getValue(Localisation localisation) {
        return CITY_BUNDLE.random(localisation) + ", " + DISTRICT_BUNDLE.random(localisation) + ", " + STREET_BUNDLE.random(localisation) + " " + RandomUtils.random(20);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

