/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.CityBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CityGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Bundle BUNDLE = new CityBundle();
    private static final Pattern PATTERN = Pattern.compile("city|town|village|settlement", 2);

    @Override
    @NotNull
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(CityGenerator.getValue(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return CityGenerator.getValue(Localisation.ENGLISH);
    }

    private static String getValue(Localisation localisation) {
        return BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

