/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.CompanyBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CompanyGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Bundle BUNDLE = new CompanyBundle();
    private static final Pattern PATTERN = Pattern.compile("org(anization)?|company|corp(oration)?|fund|business|shop|store", 2);

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(CompanyGenerator.getValue(parameters.localisation())).toString();
    }

    @Override
    public CharSequence get() {
        return CompanyGenerator.getValue(Localisation.ENGLISH);
    }

    @NotNull
    private static String getValue(@NotNull Localisation localisation) {
        return BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(5).build();
    }
}

