/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.CountryBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CountryGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Bundle BUNDLE = new CountryBundle();
    private static final Pattern PATTERN = Pattern.compile("country|citizen", 2);

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(CountryGenerator.getValue(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return CountryGenerator.getValue(Localisation.ENGLISH);
    }

    private static String getValue(@NotNull Localisation localisation) {
        return BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

