/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.FemaleNameBundle;
import io.goodforgod.dummymaker.bundle.MaleNameBundle;
import io.goodforgod.dummymaker.bundle.MiddleNameBundle;
import io.goodforgod.dummymaker.bundle.SurnameBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class FullnameGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("person|candidate|fullname|fio", 2);
    private static final Bundle MALE_BUNDLE = new MaleNameBundle();
    private static final Bundle FEMALE_BUNDLE = new FemaleNameBundle();
    private static final Bundle MIDDLE_NAME_BUNDLE = new MiddleNameBundle();
    private static final Bundle SURNAME_BUNDLE = new SurnameBundle();

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(FullnameGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return FullnameGenerator.get(Localisation.ENGLISH);
    }

    private static String get(Localisation localisation) {
        String firstName = ThreadLocalRandom.current().nextBoolean() ? MALE_BUNDLE.random(localisation) : FEMALE_BUNDLE.random(localisation);
        return firstName + " " + MIDDLE_NAME_BUNDLE.random(localisation) + " " + SURNAME_BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(60).build();
    }
}

