/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GenderGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("sex|gender", 2);

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(GenderGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return GenderGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        if (localisation == Localisation.RUSSIAN) {
            return ThreadLocalRandom.current().nextBoolean() ? "\u043c\u0443\u0436\u0447\u0438\u043d\u0430" : "\u0436\u0435\u043d\u0449\u0438\u043d\u0430";
        }
        return ThreadLocalRandom.current().nextBoolean() ? "male" : "female";
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

