/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.LoginBundle;
import io.goodforgod.dummymaker.bundle.NounBundle;
import io.goodforgod.dummymaker.cases.NamingCase;
import io.goodforgod.dummymaker.cases.NamingCases;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class JsonGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("jsonb?", 2);
    private static final Bundle FIELD_NAME_GENERATOR = new LoginBundle();
    private static final Bundle FIELD_VALUE_GENERATOR = new NounBundle();

    @Override
    public String get(@NotNull GenParameters parameters) {
        return JsonGenerator.get(parameters.localisation(), parameters.namingCase());
    }

    @Override
    public String get() {
        return JsonGenerator.get(Localisation.ENGLISH, NamingCases.DEFAULT);
    }

    private static String get(@NotNull Localisation localisation, @NotNull NamingCase namingCase) {
        int i;
        StringBuilder builder = new StringBuilder();
        int depth = RandomUtils.random(1, 6);
        for (i = 0; i < depth; ++i) {
            boolean lastDepth = i == depth - 1;
            builder.append("{");
            int lines = RandomUtils.random(1, 5);
            HashSet<String> usedFieldNames = new HashSet<String>();
            for (int j = 0; j < lines; ++j) {
                boolean lastLine;
                String fieldName = namingCase.apply(JsonGenerator.generateFieldName(localisation, usedFieldNames)).toString();
                String fieldValue = namingCase.apply(FIELD_VALUE_GENERATOR.random(localisation)).toString();
                builder.append("\"").append(fieldName).append("\"").append(":").append("\"").append(fieldValue).append("\"");
                boolean bl = lastLine = j == lines - 1;
                if (!lastLine) {
                    builder.append(",");
                }
                if (!lastLine || lastDepth) continue;
                String objectName = namingCase.apply(JsonGenerator.generateFieldName(localisation, usedFieldNames)).toString();
                builder.append(",").append("\"").append(objectName).append("\"").append(":");
            }
        }
        for (i = 0; i < depth; ++i) {
            builder.append("}");
        }
        return builder.toString();
    }

    private static String generateFieldName(Localisation localisation, Set<String> used) {
        String fieldName;
        while (used.contains(fieldName = FIELD_NAME_GENERATOR.random(localisation))) {
        }
        used.add(fieldName);
        return fieldName;
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

