/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.LoginBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class LoginGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("nick(name)?|login", 2);
    private static final Bundle BUNDLE = new LoginBundle();

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(LoginGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return LoginGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        String first = BUNDLE.random(localisation);
        boolean tuple = ThreadLocalRandom.current().nextBoolean();
        if (!tuple) {
            return first;
        }
        String second = BUNDLE.random(localisation);
        boolean revert = ThreadLocalRandom.current().nextBoolean();
        String separator = ThreadLocalRandom.current().nextBoolean() ? "_" : "";
        return revert ? second + separator + first : first + separator + second;
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

