/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.MerchantBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class MerchantGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Bundle BUNDLE = new MerchantBundle();
    private static final Pattern PATTERN = Pattern.compile("merchant|broker|dealer|seller|retailer|trader|shipper|vendor", 2);

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(MerchantGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return MerchantGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        return BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(20).build();
    }
}

