/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.FemaleNameBundle;
import io.goodforgod.dummymaker.bundle.MaleNameBundle;
import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class NameGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("user|account|name|assignee|employee?|employer|worker", 2);
    private static final Bundle MALE_BUNDLE = new MaleNameBundle();
    private static final Bundle FEMALE_BUNDLE = new FemaleNameBundle();

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(NameGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return NameGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        return ThreadLocalRandom.current().nextBoolean() ? MALE_BUNDLE.random(localisation) : FEMALE_BUNDLE.random(localisation);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(50).build();
    }
}

