/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.bundle.Bundle;
import io.goodforgod.dummymaker.bundle.PhoneCodeBundle;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class PhoneGenerator
implements Generator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("telefax|phone|mobile(phone)?|dial", 2);
    private static final Bundle PHONE_CODE_BUNDLE = new PhoneCodeBundle();
    private final boolean formatted;

    public PhoneGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    @Override
    @NotNull
    public String get() {
        int first = RandomUtils.random(100, 999);
        int second = RandomUtils.random(100, 999);
        int third = RandomUtils.random(1000, 9999);
        String prefix = PHONE_CODE_BUNDLE.random(Localisation.ENGLISH);
        if (this.formatted) {
            return "+" + prefix + first + second + third;
        }
        prefix = ThreadLocalRandom.current().nextBoolean() ? "+" + prefix : prefix;
        switch (RandomUtils.random(0, 5)) {
            case 0: {
                return prefix + " " + first + " " + second + " " + third;
            }
            case 1: {
                return prefix + "-" + first + "-" + second + "-" + third;
            }
            case 2: {
                return prefix + "(" + first + ")" + second + third;
            }
            case 3: {
                return prefix + "." + first + "." + second + "." + third;
            }
        }
        return prefix + first + second + third;
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(65).build();
    }
}

