/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class StatusGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("status|type", 2);
    private static final List<String> TYPES_RUSSIAN = Arrays.asList("\u0443\u0441\u043f\u0435\u0445", "\u043e\u0448\u0438\u0431\u043a\u0430", "\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043d\u044b\u0439", "\u043d\u0435\u0432\u0435\u0440\u043d\u043e");
    private static final List<String> TYPES_ENGLISH = Arrays.asList("success", "failed", "rejected", "invalid");

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(StatusGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return StatusGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        if (localisation == Localisation.RUSSIAN) {
            return CollectionUtils.random(TYPES_RUSSIAN);
        }
        return CollectionUtils.random(TYPES_ENGLISH);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

