/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.Random;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class StringGenerator
implements Generator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("str|string", 2);
    private static final int LEFT_LIMIT = 48;
    private static final int RIGHT_LIMIT = 122;
    private final Random random = new Random();
    private final int min;
    private final int max;

    public StringGenerator() {
        this(6, 12);
    }

    public StringGenerator(int min, int max) {
        if (min < 1) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + max + " when Min was " + min);
        }
        this.min = min;
        this.max = max;
    }

    @Override
    @NotNull
    public String get() {
        int length = RandomUtils.random(this.min, this.max);
        return this.random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

