/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.string;

import io.goodforgod.dummymaker.generator.GenParameters;
import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.generator.Localisation;
import io.goodforgod.dummymaker.generator.ParameterizedGenerator;
import io.goodforgod.dummymaker.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class TypeGenerator
implements ParameterizedGenerator<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("adjective|intense|difficult|level|lvl", 2);
    private static final List<String> TYPES_RUSSIAN = Arrays.asList("\u0423\u0436\u0430\u0441\u043d\u044b\u0439", "\u041f\u043b\u043e\u0445\u043e\u0439", "\u0423\u0434\u0440\u0443\u0447\u0430\u044e\u0449\u0438\u0439", "\u041d\u0435 \u043e\u0447\u0435\u043d\u044c", "\u041d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439", "\u041f\u043e\u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439", "\u0425\u043e\u0440\u043e\u0448\u0438\u0439", "\u0421\u0443\u043f\u0435\u0440");
    private static final List<String> TYPES_ENGLISH = Arrays.asList("Terrible", "Bad", "Poor", "Limited", "Neutral", "Average", "Decent", "Fine", "Superior");

    @Override
    public String get(@NotNull GenParameters parameters) {
        return parameters.namingCase().apply(TypeGenerator.get(parameters.localisation())).toString();
    }

    @Override
    public String get() {
        return TypeGenerator.get(Localisation.ENGLISH);
    }

    private static String get(@NotNull Localisation localisation) {
        if (localisation == Localisation.RUSSIAN) {
            return CollectionUtils.random(TYPES_RUSSIAN);
        }
        return CollectionUtils.random(TYPES_ENGLISH);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).build();
    }
}

