/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.time;

import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.time.Duration;

public final class DurationGenerator
implements Generator<Duration> {
    private final long min;
    private final long max;

    public DurationGenerator() {
        this(1L, 31557600000L);
    }

    public DurationGenerator(long min, long max) {
        if (min < 1L) {
            throw new IllegalArgumentException("Min can't be less than 1, but was: " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("Max can't be less than Min, but was " + max + " when Min was " + min);
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public Duration get() {
        return Duration.ofMillis(RandomUtils.random(this.min, this.max));
    }
}

